/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BareMetalMachineKeySetPatchProperties
implements JsonSerializable<BareMetalMachineKeySetPatchProperties> {
    private OffsetDateTime expiration;
    private List<String> jumpHostsAllowed;
    private List<KeySetUser> userList;

    public OffsetDateTime expiration() {
        return this.expiration;
    }

    public BareMetalMachineKeySetPatchProperties withExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public List<String> jumpHostsAllowed() {
        return this.jumpHostsAllowed;
    }

    public BareMetalMachineKeySetPatchProperties withJumpHostsAllowed(List<String> jumpHostsAllowed) {
        this.jumpHostsAllowed = jumpHostsAllowed;
        return this;
    }

    public List<KeySetUser> userList() {
        return this.userList;
    }

    public BareMetalMachineKeySetPatchProperties withUserList(List<KeySetUser> userList) {
        this.userList = userList;
        return this;
    }

    public void validate() {
        if (this.userList() != null) {
            this.userList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("expiration", this.expiration == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiration));
        jsonWriter.writeArrayField("jumpHostsAllowed", this.jumpHostsAllowed, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("userList", this.userList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineKeySetPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineKeySetPatchProperties)jsonReader.readObject(reader -> {
            BareMetalMachineKeySetPatchProperties deserializedBareMetalMachineKeySetPatchProperties = new BareMetalMachineKeySetPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expiration".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetPatchProperties.expiration = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("jumpHostsAllowed".equals(fieldName)) {
                    List jumpHostsAllowed;
                    deserializedBareMetalMachineKeySetPatchProperties.jumpHostsAllowed = jumpHostsAllowed = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("userList".equals(fieldName)) {
                    List userList;
                    deserializedBareMetalMachineKeySetPatchProperties.userList = userList = reader.readArray(reader1 -> KeySetUser.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineKeySetPatchProperties;
        });
    }
}

