/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.JsonWebKeyType;
import com.azure.resourcemanager.hardwaresecuritymodules.models.NetworkProfile;
import java.io.IOException;

public final class DedicatedHsmProperties
implements JsonSerializable<DedicatedHsmProperties> {
    private NetworkProfile networkProfile;
    private NetworkProfile managementNetworkProfile;
    private String stampId;
    private String statusMessage;
    private JsonWebKeyType provisioningState;

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public DedicatedHsmProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public NetworkProfile managementNetworkProfile() {
        return this.managementNetworkProfile;
    }

    public DedicatedHsmProperties withManagementNetworkProfile(NetworkProfile managementNetworkProfile) {
        this.managementNetworkProfile = managementNetworkProfile;
        return this;
    }

    public String stampId() {
        return this.stampId;
    }

    public DedicatedHsmProperties withStampId(String stampId) {
        this.stampId = stampId;
        return this;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public JsonWebKeyType provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.managementNetworkProfile() != null) {
            this.managementNetworkProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("networkProfile", (JsonSerializable)this.networkProfile);
        jsonWriter.writeJsonField("managementNetworkProfile", (JsonSerializable)this.managementNetworkProfile);
        jsonWriter.writeStringField("stampId", this.stampId);
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHsmProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DedicatedHsmProperties)jsonReader.readObject(reader -> {
            DedicatedHsmProperties deserializedDedicatedHsmProperties = new DedicatedHsmProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkProfile".equals(fieldName)) {
                    deserializedDedicatedHsmProperties.networkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("managementNetworkProfile".equals(fieldName)) {
                    deserializedDedicatedHsmProperties.managementNetworkProfile = NetworkProfile.fromJson(reader);
                    continue;
                }
                if ("stampId".equals(fieldName)) {
                    deserializedDedicatedHsmProperties.stampId = reader.getString();
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedDedicatedHsmProperties.statusMessage = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDedicatedHsmProperties.provisioningState = JsonWebKeyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHsmProperties;
        });
    }
}

