/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.DedicatedHsmInner;
import java.io.IOException;
import java.util.List;

public final class DedicatedHsmListResult
implements JsonSerializable<DedicatedHsmListResult> {
    private List<DedicatedHsmInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHsmListResult.class);

    private DedicatedHsmListResult() {
    }

    public List<DedicatedHsmInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DedicatedHsmListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHsmListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DedicatedHsmListResult)jsonReader.readObject(reader -> {
            DedicatedHsmListResult deserializedDedicatedHsmListResult = new DedicatedHsmListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDedicatedHsmListResult.value = value = reader.readArray(reader1 -> DedicatedHsmInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDedicatedHsmListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHsmListResult;
        });
    }
}

