/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.CloudHsmClusterInner;
import java.io.IOException;
import java.util.List;

public final class CloudHsmClusterListResult
implements JsonSerializable<CloudHsmClusterListResult> {
    private List<CloudHsmClusterInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClusterListResult.class);

    private CloudHsmClusterListResult() {
    }

    public List<CloudHsmClusterInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CloudHsmClusterListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CloudHsmClusterListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CloudHsmClusterListResult)jsonReader.readObject(reader -> {
            CloudHsmClusterListResult deserializedCloudHsmClusterListResult = new CloudHsmClusterListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCloudHsmClusterListResult.value = value = reader.readArray(reader1 -> CloudHsmClusterInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCloudHsmClusterListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudHsmClusterListResult;
        });
    }
}

