/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.DedicatedHsmInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.hardwaresecuritymodules.models.DedicatedHsm;
import com.azure.resourcemanager.hardwaresecuritymodules.models.DedicatedHsmPatchParameters;
import com.azure.resourcemanager.hardwaresecuritymodules.models.DedicatedHsmProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.Sku;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DedicatedHsmImpl
implements DedicatedHsm,
DedicatedHsm.Definition,
DedicatedHsm.Update {
    private DedicatedHsmInner innerObject;
    private final HardwareSecurityModulesManager serviceManager;
    private String resourceGroupName;
    private String name;
    private DedicatedHsmPatchParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public DedicatedHsmProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DedicatedHsmInner innerModel() {
        return this.innerObject;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }

    @Override
    public DedicatedHsmImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DedicatedHsm create() {
        this.innerObject = this.serviceManager.serviceClient().getDedicatedHsms().createOrUpdate(this.resourceGroupName, this.name, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DedicatedHsm create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDedicatedHsms().createOrUpdate(this.resourceGroupName, this.name, this.innerModel(), context);
        return this;
    }

    DedicatedHsmImpl(String name, HardwareSecurityModulesManager serviceManager) {
        this.innerObject = new DedicatedHsmInner();
        this.serviceManager = serviceManager;
        this.name = name;
    }

    @Override
    public DedicatedHsmImpl update() {
        this.updateParameters = new DedicatedHsmPatchParameters();
        return this;
    }

    @Override
    public DedicatedHsm apply() {
        this.innerObject = this.serviceManager.serviceClient().getDedicatedHsms().update(this.resourceGroupName, this.name, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public DedicatedHsm apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDedicatedHsms().update(this.resourceGroupName, this.name, this.updateParameters, context);
        return this;
    }

    DedicatedHsmImpl(DedicatedHsmInner innerObject, HardwareSecurityModulesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.name = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dedicatedHSMs");
    }

    @Override
    public DedicatedHsm refresh() {
        this.innerObject = (DedicatedHsmInner)((Object)this.serviceManager.serviceClient().getDedicatedHsms().getByResourceGroupWithResponse(this.resourceGroupName, this.name, Context.NONE).getValue());
        return this;
    }

    @Override
    public DedicatedHsm refresh(Context context) {
        this.innerObject = (DedicatedHsmInner)((Object)this.serviceManager.serviceClient().getDedicatedHsms().getByResourceGroupWithResponse(this.resourceGroupName, this.name, context).getValue());
        return this;
    }

    @Override
    public DedicatedHsmImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DedicatedHsmImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DedicatedHsmImpl withSku(Sku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public DedicatedHsmImpl withProperties(DedicatedHsmProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public DedicatedHsmImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DedicatedHsmImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

