/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.CloudHsmClustersClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.BackupResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.CloudHsmClusterInner;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.RestoreResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.BackupResultImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.CloudHsmClusterImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.RestoreResultImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupResult;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmCluster;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusters;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreRequestProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.RestoreResult;

public final class CloudHsmClustersImpl
implements CloudHsmClusters {
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClustersImpl.class);
    private final CloudHsmClustersClient innerClient;
    private final HardwareSecurityModulesManager serviceManager;

    public CloudHsmClustersImpl(CloudHsmClustersClient innerClient, HardwareSecurityModulesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CloudHsmCluster> getByResourceGroupWithResponse(String resourceGroupName, String cloudHsmClusterName, Context context) {
        Response<CloudHsmClusterInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, cloudHsmClusterName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CloudHsmClusterImpl((CloudHsmClusterInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CloudHsmCluster getByResourceGroup(String resourceGroupName, String cloudHsmClusterName) {
        CloudHsmClusterInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, cloudHsmClusterName);
        if (inner != null) {
            return new CloudHsmClusterImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String cloudHsmClusterName) {
        this.serviceClient().delete(resourceGroupName, cloudHsmClusterName);
    }

    @Override
    public void delete(String resourceGroupName, String cloudHsmClusterName, Context context) {
        this.serviceClient().delete(resourceGroupName, cloudHsmClusterName, context);
    }

    @Override
    public PagedIterable<CloudHsmCluster> listByResourceGroup(String resourceGroupName) {
        PagedIterable<CloudHsmClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudHsmClusterImpl((CloudHsmClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CloudHsmCluster> listByResourceGroup(String resourceGroupName, String skiptoken, Context context) {
        PagedIterable<CloudHsmClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, skiptoken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudHsmClusterImpl((CloudHsmClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CloudHsmCluster> list() {
        PagedIterable<CloudHsmClusterInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudHsmClusterImpl((CloudHsmClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CloudHsmCluster> list(String skiptoken, Context context) {
        PagedIterable<CloudHsmClusterInner> inner = this.serviceClient().list(skiptoken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudHsmClusterImpl((CloudHsmClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public BackupResult validateBackupProperties(String resourceGroupName, String cloudHsmClusterName) {
        BackupResultInner inner = this.serviceClient().validateBackupProperties(resourceGroupName, cloudHsmClusterName);
        if (inner != null) {
            return new BackupResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupResult validateBackupProperties(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        BackupResultInner inner = this.serviceClient().validateBackupProperties(resourceGroupName, cloudHsmClusterName, backupRequestProperties, context);
        if (inner != null) {
            return new BackupResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupResult backup(String resourceGroupName, String cloudHsmClusterName) {
        BackupResultInner inner = this.serviceClient().backup(resourceGroupName, cloudHsmClusterName);
        if (inner != null) {
            return new BackupResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupResult backup(String resourceGroupName, String cloudHsmClusterName, BackupRequestProperties backupRequestProperties, Context context) {
        BackupResultInner inner = this.serviceClient().backup(resourceGroupName, cloudHsmClusterName, backupRequestProperties, context);
        if (inner != null) {
            return new BackupResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RestoreResult validateRestoreProperties(String resourceGroupName, String cloudHsmClusterName) {
        RestoreResultInner inner = this.serviceClient().validateRestoreProperties(resourceGroupName, cloudHsmClusterName);
        if (inner != null) {
            return new RestoreResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RestoreResult validateRestoreProperties(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        RestoreResultInner inner = this.serviceClient().validateRestoreProperties(resourceGroupName, cloudHsmClusterName, restoreRequestProperties, context);
        if (inner != null) {
            return new RestoreResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RestoreResult restore(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties) {
        RestoreResultInner inner = this.serviceClient().restore(resourceGroupName, cloudHsmClusterName, restoreRequestProperties);
        if (inner != null) {
            return new RestoreResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RestoreResult restore(String resourceGroupName, String cloudHsmClusterName, RestoreRequestProperties restoreRequestProperties, Context context) {
        RestoreResultInner inner = this.serviceClient().restore(resourceGroupName, cloudHsmClusterName, restoreRequestProperties, context);
        if (inner != null) {
            return new RestoreResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public CloudHsmCluster getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudHsmClusterName = ResourceManagerUtils.getValueFromIdByName(id, "cloudHsmClusters");
        if (cloudHsmClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudHsmClusters'.", id)));
        }
        return (CloudHsmCluster)this.getByResourceGroupWithResponse(resourceGroupName, cloudHsmClusterName, Context.NONE).getValue();
    }

    @Override
    public Response<CloudHsmCluster> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudHsmClusterName = ResourceManagerUtils.getValueFromIdByName(id, "cloudHsmClusters");
        if (cloudHsmClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudHsmClusters'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, cloudHsmClusterName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudHsmClusterName = ResourceManagerUtils.getValueFromIdByName(id, "cloudHsmClusters");
        if (cloudHsmClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudHsmClusters'.", id)));
        }
        this.delete(resourceGroupName, cloudHsmClusterName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudHsmClusterName = ResourceManagerUtils.getValueFromIdByName(id, "cloudHsmClusters");
        if (cloudHsmClusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudHsmClusters'.", id)));
        }
        this.delete(resourceGroupName, cloudHsmClusterName, context);
    }

    private CloudHsmClustersClient serviceClient() {
        return this.innerClient;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }

    @Override
    public CloudHsmClusterImpl define(String name) {
        return new CloudHsmClusterImpl(name, this.manager());
    }
}

