/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.CloudHsmClusterRestoreStatusClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.RestoreResultInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.HardwareSecurityModulesManagementClientImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterRestoreStatusGetResponse;
import reactor.core.publisher.Mono;

public final class CloudHsmClusterRestoreStatusClientImpl
implements CloudHsmClusterRestoreStatusClient {
    private final CloudHsmClusterRestoreStatusService service;
    private final HardwareSecurityModulesManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClusterRestoreStatusClientImpl.class);

    CloudHsmClusterRestoreStatusClientImpl(HardwareSecurityModulesManagementClientImpl client) {
        this.service = (CloudHsmClusterRestoreStatusService)RestProxy.create(CloudHsmClusterRestoreStatusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudHsmClusterRestoreStatusGetResponse> getWithResponseAsync(String resourceGroupName, String cloudHsmClusterName, String jobId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (jobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, jobId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RestoreResultInner> getAsync(String resourceGroupName, String cloudHsmClusterName, String jobId) {
        return this.getWithResponseAsync(resourceGroupName, cloudHsmClusterName, jobId).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudHsmClusterRestoreStatusGetResponse getWithResponse(String resourceGroupName, String cloudHsmClusterName, String jobId, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudHsmClusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudHsmClusterName is required and cannot be null."));
        }
        if (jobId == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter jobId is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudHsmClusterName, jobId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreResultInner get(String resourceGroupName, String cloudHsmClusterName, String jobId) {
        return this.getWithResponse(resourceGroupName, cloudHsmClusterName, jobId, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="HardwareSecurityModulesManagementClientCloudHsmClusterRestoreStatus")
    public static interface CloudHsmClusterRestoreStatusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/restoreOperationStatus/{jobId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<CloudHsmClusterRestoreStatusGetResponse> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @PathParam(value="jobId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/restoreOperationStatus/{jobId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public CloudHsmClusterRestoreStatusGetResponse getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudHsmClusterName") String var5, @PathParam(value="jobId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

