/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.hardwaresecuritymodules.HardwareSecurityModulesManager;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.CloudHsmClusterPrivateLinkResourcesClient;
import com.azure.resourcemanager.hardwaresecuritymodules.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.hardwaresecuritymodules.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterPrivateLinkResources;
import com.azure.resourcemanager.hardwaresecuritymodules.models.PrivateLinkResource;

public final class CloudHsmClusterPrivateLinkResourcesImpl
implements CloudHsmClusterPrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(CloudHsmClusterPrivateLinkResourcesImpl.class);
    private final CloudHsmClusterPrivateLinkResourcesClient innerClient;
    private final HardwareSecurityModulesManager serviceManager;

    public CloudHsmClusterPrivateLinkResourcesImpl(CloudHsmClusterPrivateLinkResourcesClient innerClient, HardwareSecurityModulesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByCloudHsmCluster(String resourceGroupName, String cloudHsmClusterName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByCloudHsmCluster(resourceGroupName, cloudHsmClusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByCloudHsmCluster(String resourceGroupName, String cloudHsmClusterName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByCloudHsmCluster(resourceGroupName, cloudHsmClusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    private CloudHsmClusterPrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private HardwareSecurityModulesManager manager() {
        return this.serviceManager;
    }
}

