/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.durabletask.DurableTaskManager;
import com.azure.resourcemanager.durabletask.fluent.TaskHubsClient;
import com.azure.resourcemanager.durabletask.fluent.models.TaskHubInner;
import com.azure.resourcemanager.durabletask.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.durabletask.implementation.TaskHubImpl;
import com.azure.resourcemanager.durabletask.models.TaskHub;
import com.azure.resourcemanager.durabletask.models.TaskHubs;

public final class TaskHubsImpl
implements TaskHubs {
    private static final ClientLogger LOGGER = new ClientLogger(TaskHubsImpl.class);
    private final TaskHubsClient innerClient;
    private final DurableTaskManager serviceManager;

    public TaskHubsImpl(TaskHubsClient innerClient, DurableTaskManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<TaskHub> getWithResponse(String resourceGroupName, String schedulerName, String taskHubName, Context context) {
        Response<TaskHubInner> inner = this.serviceClient().getWithResponse(resourceGroupName, schedulerName, taskHubName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TaskHubImpl((TaskHubInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public TaskHub get(String resourceGroupName, String schedulerName, String taskHubName) {
        TaskHubInner inner = this.serviceClient().get(resourceGroupName, schedulerName, taskHubName);
        if (inner != null) {
            return new TaskHubImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String schedulerName, String taskHubName) {
        this.serviceClient().delete(resourceGroupName, schedulerName, taskHubName);
    }

    @Override
    public void delete(String resourceGroupName, String schedulerName, String taskHubName, Context context) {
        this.serviceClient().delete(resourceGroupName, schedulerName, taskHubName, context);
    }

    @Override
    public PagedIterable<TaskHub> listByScheduler(String resourceGroupName, String schedulerName) {
        PagedIterable<TaskHubInner> inner = this.serviceClient().listByScheduler(resourceGroupName, schedulerName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TaskHubImpl((TaskHubInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<TaskHub> listByScheduler(String resourceGroupName, String schedulerName, Context context) {
        PagedIterable<TaskHubInner> inner = this.serviceClient().listByScheduler(resourceGroupName, schedulerName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new TaskHubImpl((TaskHubInner)((Object)inner1), this.manager()));
    }

    @Override
    public TaskHub getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        String taskHubName = ResourceManagerUtils.getValueFromIdByName(id, "taskHubs");
        if (taskHubName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'taskHubs'.", id)));
        }
        return (TaskHub)this.getWithResponse(resourceGroupName, schedulerName, taskHubName, Context.NONE).getValue();
    }

    @Override
    public Response<TaskHub> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        String taskHubName = ResourceManagerUtils.getValueFromIdByName(id, "taskHubs");
        if (taskHubName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'taskHubs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, schedulerName, taskHubName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        String taskHubName = ResourceManagerUtils.getValueFromIdByName(id, "taskHubs");
        if (taskHubName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'taskHubs'.", id)));
        }
        this.delete(resourceGroupName, schedulerName, taskHubName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schedulerName = ResourceManagerUtils.getValueFromIdByName(id, "schedulers");
        if (schedulerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schedulers'.", id)));
        }
        String taskHubName = ResourceManagerUtils.getValueFromIdByName(id, "taskHubs");
        if (taskHubName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'taskHubs'.", id)));
        }
        this.delete(resourceGroupName, schedulerName, taskHubName, context);
    }

    private TaskHubsClient serviceClient() {
        return this.innerClient;
    }

    private DurableTaskManager manager() {
        return this.serviceManager;
    }

    @Override
    public TaskHubImpl define(String name) {
        return new TaskHubImpl(name, this.manager());
    }
}

