/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SsisMigrationOverwriteOption;
import com.azure.resourcemanager.datamigration.models.SsisStoreType;
import java.io.IOException;

public final class SsisMigrationInfo
implements JsonSerializable<SsisMigrationInfo> {
    private SsisStoreType ssisStoreType;
    private SsisMigrationOverwriteOption projectOverwriteOption;
    private SsisMigrationOverwriteOption environmentOverwriteOption;

    public SsisStoreType ssisStoreType() {
        return this.ssisStoreType;
    }

    public SsisMigrationInfo withSsisStoreType(SsisStoreType ssisStoreType) {
        this.ssisStoreType = ssisStoreType;
        return this;
    }

    public SsisMigrationOverwriteOption projectOverwriteOption() {
        return this.projectOverwriteOption;
    }

    public SsisMigrationInfo withProjectOverwriteOption(SsisMigrationOverwriteOption projectOverwriteOption) {
        this.projectOverwriteOption = projectOverwriteOption;
        return this;
    }

    public SsisMigrationOverwriteOption environmentOverwriteOption() {
        return this.environmentOverwriteOption;
    }

    public SsisMigrationInfo withEnvironmentOverwriteOption(SsisMigrationOverwriteOption environmentOverwriteOption) {
        this.environmentOverwriteOption = environmentOverwriteOption;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ssisStoreType", this.ssisStoreType == null ? null : this.ssisStoreType.toString());
        jsonWriter.writeStringField("projectOverwriteOption", this.projectOverwriteOption == null ? null : this.projectOverwriteOption.toString());
        jsonWriter.writeStringField("environmentOverwriteOption", this.environmentOverwriteOption == null ? null : this.environmentOverwriteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static SsisMigrationInfo fromJson(JsonReader jsonReader) throws IOException {
        return (SsisMigrationInfo)jsonReader.readObject(reader -> {
            SsisMigrationInfo deserializedSsisMigrationInfo = new SsisMigrationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ssisStoreType".equals(fieldName)) {
                    deserializedSsisMigrationInfo.ssisStoreType = SsisStoreType.fromString(reader.getString());
                    continue;
                }
                if ("projectOverwriteOption".equals(fieldName)) {
                    deserializedSsisMigrationInfo.projectOverwriteOption = SsisMigrationOverwriteOption.fromString(reader.getString());
                    continue;
                }
                if ("environmentOverwriteOption".equals(fieldName)) {
                    deserializedSsisMigrationInfo.environmentOverwriteOption = SsisMigrationOverwriteOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisMigrationInfo;
        });
    }
}

