/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.FileShare;
import com.azure.resourcemanager.datamigration.models.MiSqlConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMIDatabaseInput;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public class SqlServerSqlMISyncTaskInput
implements JsonSerializable<SqlServerSqlMISyncTaskInput> {
    private List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases;
    private FileShare backupFileShare;
    private String storageResourceId;
    private SqlConnectionInfo sourceConnectionInfo;
    private MiSqlConnectionInfo targetConnectionInfo;
    private AzureActiveDirectoryApp azureApp;
    private static final ClientLogger LOGGER = new ClientLogger(SqlServerSqlMISyncTaskInput.class);

    public List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public SqlServerSqlMISyncTaskInput withSelectedDatabases(List<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public FileShare backupFileShare() {
        return this.backupFileShare;
    }

    public SqlServerSqlMISyncTaskInput withBackupFileShare(FileShare backupFileShare) {
        this.backupFileShare = backupFileShare;
        return this;
    }

    public String storageResourceId() {
        return this.storageResourceId;
    }

    public SqlServerSqlMISyncTaskInput withStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
        return this;
    }

    public SqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public SqlServerSqlMISyncTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public MiSqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public SqlServerSqlMISyncTaskInput withTargetConnectionInfo(MiSqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public AzureActiveDirectoryApp azureApp() {
        return this.azureApp;
    }

    public SqlServerSqlMISyncTaskInput withAzureApp(AzureActiveDirectoryApp azureApp) {
        this.azureApp = azureApp;
        return this;
    }

    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model SqlServerSqlMISyncTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.backupFileShare() != null) {
            this.backupFileShare().validate();
        }
        if (this.storageResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageResourceId in model SqlServerSqlMISyncTaskInput"));
        }
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model SqlServerSqlMISyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model SqlServerSqlMISyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.azureApp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property azureApp in model SqlServerSqlMISyncTaskInput"));
        }
        this.azureApp().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("storageResourceId", this.storageResourceId);
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeJsonField("azureApp", (JsonSerializable)this.azureApp);
        jsonWriter.writeJsonField("backupFileShare", (JsonSerializable)this.backupFileShare);
        return jsonWriter.writeEndObject();
    }

    public static SqlServerSqlMISyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerSqlMISyncTaskInput)jsonReader.readObject(reader -> {
            SqlServerSqlMISyncTaskInput deserializedSqlServerSqlMISyncTaskInput = new SqlServerSqlMISyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedSqlServerSqlMISyncTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateSqlServerSqlMIDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("storageResourceId".equals(fieldName)) {
                    deserializedSqlServerSqlMISyncTaskInput.storageResourceId = reader.getString();
                    continue;
                }
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedSqlServerSqlMISyncTaskInput.sourceConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedSqlServerSqlMISyncTaskInput.targetConnectionInfo = MiSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("azureApp".equals(fieldName)) {
                    deserializedSqlServerSqlMISyncTaskInput.azureApp = AzureActiveDirectoryApp.fromJson(reader);
                    continue;
                }
                if ("backupFileShare".equals(fieldName)) {
                    deserializedSqlServerSqlMISyncTaskInput.backupFileShare = FileShare.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlServerSqlMISyncTaskInput;
        });
    }
}

