/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.CheckOciDriverTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToMongoDbTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceMySqlTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceOracleSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToSourcePostgreSqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceSqlServerSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceSqlServerTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetAzureDbForMySqlTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlDbSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlDbTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlMISyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlMITaskProperties;
import com.azure.resourcemanager.datamigration.models.GetTdeCertificatesSqlTaskProperties;
import com.azure.resourcemanager.datamigration.models.GetUserTablesMySqlTaskProperties;
import com.azure.resourcemanager.datamigration.models.GetUserTablesOracleTaskProperties;
import com.azure.resourcemanager.datamigration.models.GetUserTablesPostgreSqlTaskProperties;
import com.azure.resourcemanager.datamigration.models.GetUserTablesSqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.GetUserTablesSqlTaskProperties;
import com.azure.resourcemanager.datamigration.models.InstallOciDriverTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateMongoDbTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateMySqlAzureDbForMySqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateOracleAzureDbForPostgreSqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSchemaSqlServerSqlDbTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMISyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSsisTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import com.azure.resourcemanager.datamigration.models.UploadOciDriverTaskProperties;
import com.azure.resourcemanager.datamigration.models.ValidateMigrationInputSqlServerSqlDbSyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ValidateMigrationInputSqlServerSqlMISyncTaskProperties;
import com.azure.resourcemanager.datamigration.models.ValidateMigrationInputSqlServerSqlMITaskProperties;
import com.azure.resourcemanager.datamigration.models.ValidateMongoDbTaskProperties;
import com.azure.resourcemanager.datamigration.models.ValidateOracleAzureDbForPostgreSqlSyncTaskProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ProjectTaskProperties
implements JsonSerializable<ProjectTaskProperties> {
    private TaskType taskType = TaskType.fromString("ProjectTaskProperties");
    private List<ManagementError> errors;
    private TaskState state;
    private List<CommandPropertiesInner> commands;
    private Map<String, String> clientData;

    public TaskType taskType() {
        return this.taskType;
    }

    public List<ManagementError> errors() {
        return this.errors;
    }

    ProjectTaskProperties withErrors(List<ManagementError> errors) {
        this.errors = errors;
        return this;
    }

    public TaskState state() {
        return this.state;
    }

    ProjectTaskProperties withState(TaskState state) {
        this.state = state;
        return this;
    }

    public List<CommandPropertiesInner> commands() {
        return this.commands;
    }

    ProjectTaskProperties withCommands(List<CommandPropertiesInner> commands) {
        this.commands = commands;
        return this;
    }

    public Map<String, String> clientData() {
        return this.clientData;
    }

    public ProjectTaskProperties withClientData(Map<String, String> clientData) {
        this.clientData = clientData;
        return this;
    }

    public void validate() {
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeMapField("clientData", this.clientData, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ProjectTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectTaskProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ProjectTaskProperties projectTaskProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("taskType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("MigrateSchemaSqlServerSqlDb".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateSchemaSqlServerSqlDbTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Service.Check.OCI".equals(discriminatorValue)) {
                    projectTaskProperties = CheckOciDriverTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Service.Upload.OCI".equals(discriminatorValue)) {
                    projectTaskProperties = UploadOciDriverTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Service.Install.OCI".equals(discriminatorValue)) {
                    projectTaskProperties = InstallOciDriverTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Connect.MongoDb".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToMongoDbTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToSource.SqlServer".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToSourceSqlServerTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToSource.SqlServer.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToSourceSqlServerSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToSource.PostgreSql.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToSourcePostgreSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToSource.MySql".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToSourceMySqlTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToSource.Oracle.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToSourceOracleSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.SqlDb".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetSqlDbTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.SqlDb.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetSqlDbSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.AzureDbForPostgreSql.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetAzureDbForPostgreSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetOracleAzureDbForPostgreSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("GetUserTables.Sql".equals(discriminatorValue)) {
                    projectTaskProperties = GetUserTablesSqlTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("GetUserTables.AzureSqlDb.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = GetUserTablesSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("GetUserTablesOracle".equals(discriminatorValue)) {
                    projectTaskProperties = GetUserTablesOracleTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("GetUserTablesPostgreSql".equals(discriminatorValue)) {
                    projectTaskProperties = GetUserTablesPostgreSqlTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("GetUserTablesMySql".equals(discriminatorValue)) {
                    projectTaskProperties = GetUserTablesMySqlTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.AzureSqlDbMI".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetSqlMITaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.AzureSqlDbMI.Sync.LRS".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetSqlMISyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ConnectToTarget.AzureDbForMySql".equals(discriminatorValue)) {
                    projectTaskProperties = ConnectToTargetAzureDbForMySqlTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.MongoDb".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateMongoDbTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.SqlServer.AzureSqlDbMI".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateSqlServerSqlMITaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.SqlServer.AzureSqlDbMI.Sync.LRS".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateSqlServerSqlMISyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.SqlServer.SqlDb".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateSqlServerSqlDbTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.SqlServer.AzureSqlDb.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateSqlServerSqlDbSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.MySql.AzureDbForMySql.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateMySqlAzureDbForMySqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.MySql.AzureDbForMySql".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateMySqlAzureDbForMySqlOfflineTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2".equals(discriminatorValue)) {
                    projectTaskProperties = MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.Oracle.AzureDbForPostgreSql.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateOracleAzureDbForPostgreSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ValidateMigrationInput.SqlServer.SqlDb.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ValidateMigrationInputSqlServerSqlDbSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ValidateMigrationInput.SqlServer.AzureSqlDbMI".equals(discriminatorValue)) {
                    projectTaskProperties = ValidateMigrationInputSqlServerSqlMITaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS".equals(discriminatorValue)) {
                    projectTaskProperties = ValidateMigrationInputSqlServerSqlMISyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Validate.MongoDb".equals(discriminatorValue)) {
                    projectTaskProperties = ValidateMongoDbTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Validate.Oracle.AzureDbPostgreSql.Sync".equals(discriminatorValue)) {
                    projectTaskProperties = ValidateOracleAzureDbForPostgreSqlSyncTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("GetTDECertificates.Sql".equals(discriminatorValue)) {
                    projectTaskProperties = GetTdeCertificatesSqlTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                if ("Migrate.Ssis".equals(discriminatorValue)) {
                    projectTaskProperties = MigrateSsisTaskProperties.fromJson(readerToUse.reset());
                    return projectTaskProperties;
                }
                projectTaskProperties = ProjectTaskProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return projectTaskProperties;
            }
        });
    }

    static ProjectTaskProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ProjectTaskProperties)jsonReader.readObject(reader -> {
            ProjectTaskProperties deserializedProjectTaskProperties = new ProjectTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskType".equals(fieldName)) {
                    deserializedProjectTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedProjectTaskProperties.errors = errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedProjectTaskProperties.state = TaskState.fromString(reader.getString());
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands;
                    deserializedProjectTaskProperties.commands = commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData;
                    deserializedProjectTaskProperties.clientData = clientData = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectTaskProperties;
        });
    }
}

