/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbShardKeyOrder;
import java.io.IOException;

public final class MongoDbShardKeyField
implements JsonSerializable<MongoDbShardKeyField> {
    private String name;
    private MongoDbShardKeyOrder order;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbShardKeyField.class);

    public String name() {
        return this.name;
    }

    public MongoDbShardKeyField withName(String name) {
        this.name = name;
        return this;
    }

    public MongoDbShardKeyOrder order() {
        return this.order;
    }

    public MongoDbShardKeyField withOrder(MongoDbShardKeyOrder order) {
        this.order = order;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MongoDbShardKeyField"));
        }
        if (this.order() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property order in model MongoDbShardKeyField"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("order", this.order == null ? null : this.order.toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDbShardKeyField fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbShardKeyField)jsonReader.readObject(reader -> {
            MongoDbShardKeyField deserializedMongoDbShardKeyField = new MongoDbShardKeyField();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMongoDbShardKeyField.name = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedMongoDbShardKeyField.order = MongoDbShardKeyOrder.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbShardKeyField;
        });
    }
}

