/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbConnectionInfo;
import com.azure.resourcemanager.datamigration.models.MongoDbDatabaseSettings;
import com.azure.resourcemanager.datamigration.models.MongoDbReplication;
import com.azure.resourcemanager.datamigration.models.MongoDbThrottlingSettings;
import java.io.IOException;
import java.util.Map;

public final class MongoDbMigrationSettings
implements JsonSerializable<MongoDbMigrationSettings> {
    private Integer boostRUs;
    private Map<String, MongoDbDatabaseSettings> databases;
    private MongoDbReplication replication;
    private MongoDbConnectionInfo source;
    private MongoDbConnectionInfo target;
    private MongoDbThrottlingSettings throttling;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbMigrationSettings.class);

    public Integer boostRUs() {
        return this.boostRUs;
    }

    public MongoDbMigrationSettings withBoostRUs(Integer boostRUs) {
        this.boostRUs = boostRUs;
        return this;
    }

    public Map<String, MongoDbDatabaseSettings> databases() {
        return this.databases;
    }

    public MongoDbMigrationSettings withDatabases(Map<String, MongoDbDatabaseSettings> databases) {
        this.databases = databases;
        return this;
    }

    public MongoDbReplication replication() {
        return this.replication;
    }

    public MongoDbMigrationSettings withReplication(MongoDbReplication replication) {
        this.replication = replication;
        return this;
    }

    public MongoDbConnectionInfo source() {
        return this.source;
    }

    public MongoDbMigrationSettings withSource(MongoDbConnectionInfo source) {
        this.source = source;
        return this;
    }

    public MongoDbConnectionInfo target() {
        return this.target;
    }

    public MongoDbMigrationSettings withTarget(MongoDbConnectionInfo target) {
        this.target = target;
        return this;
    }

    public MongoDbThrottlingSettings throttling() {
        return this.throttling;
    }

    public MongoDbMigrationSettings withThrottling(MongoDbThrottlingSettings throttling) {
        this.throttling = throttling;
        return this;
    }

    public void validate() {
        if (this.databases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databases in model MongoDbMigrationSettings"));
        }
        this.databases().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
        if (this.source() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property source in model MongoDbMigrationSettings"));
        }
        this.source().validate();
        if (this.target() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property target in model MongoDbMigrationSettings"));
        }
        this.target().validate();
        if (this.throttling() != null) {
            this.throttling().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        jsonWriter.writeNumberField("boostRUs", (Number)this.boostRUs);
        jsonWriter.writeStringField("replication", this.replication == null ? null : this.replication.toString());
        jsonWriter.writeJsonField("throttling", (JsonSerializable)this.throttling);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbMigrationSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbMigrationSettings)jsonReader.readObject(reader -> {
            MongoDbMigrationSettings deserializedMongoDbMigrationSettings = new MongoDbMigrationSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databases".equals(fieldName)) {
                    Map databases;
                    deserializedMongoDbMigrationSettings.databases = databases = reader.readMap(reader1 -> MongoDbDatabaseSettings.fromJson(reader1));
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedMongoDbMigrationSettings.source = MongoDbConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedMongoDbMigrationSettings.target = MongoDbConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("boostRUs".equals(fieldName)) {
                    deserializedMongoDbMigrationSettings.boostRUs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("replication".equals(fieldName)) {
                    deserializedMongoDbMigrationSettings.replication = MongoDbReplication.fromString(reader.getString());
                    continue;
                }
                if ("throttling".equals(fieldName)) {
                    deserializedMongoDbMigrationSettings.throttling = MongoDbThrottlingSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbMigrationSettings;
        });
    }
}

