/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.CommandState;
import com.azure.resourcemanager.datamigration.models.CommandType;
import com.azure.resourcemanager.datamigration.models.MongoDbFinishCommandInput;
import java.io.IOException;
import java.util.List;

public final class MongoDbFinishCommand
extends CommandPropertiesInner {
    private CommandType commandType = CommandType.FINISH;
    private MongoDbFinishCommandInput input;
    private CommandState state;
    private List<ManagementError> errors;

    @Override
    public CommandType commandType() {
        return this.commandType;
    }

    public MongoDbFinishCommandInput input() {
        return this.input;
    }

    public MongoDbFinishCommand withInput(MongoDbFinishCommandInput input) {
        this.input = input;
        return this;
    }

    @Override
    public CommandState state() {
        return this.state;
    }

    @Override
    public List<ManagementError> errors() {
        return this.errors;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandType", this.commandType == null ? null : this.commandType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbFinishCommand fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbFinishCommand)jsonReader.readObject(reader -> {
            MongoDbFinishCommand deserializedMongoDbFinishCommand = new MongoDbFinishCommand();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedMongoDbFinishCommand.errors = errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMongoDbFinishCommand.state = CommandState.fromString(reader.getString());
                    continue;
                }
                if ("commandType".equals(fieldName)) {
                    deserializedMongoDbFinishCommand.commandType = CommandType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMongoDbFinishCommand.input = MongoDbFinishCommandInput.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbFinishCommand;
        });
    }
}

