/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbErrorType;
import java.io.IOException;

public final class MongoDbError
implements JsonSerializable<MongoDbError> {
    private String code;
    private Integer count;
    private String message;
    private MongoDbErrorType type;

    public String code() {
        return this.code;
    }

    public MongoDbError withCode(String code) {
        this.code = code;
        return this;
    }

    public Integer count() {
        return this.count;
    }

    public MongoDbError withCount(Integer count) {
        this.count = count;
        return this;
    }

    public String message() {
        return this.message;
    }

    public MongoDbError withMessage(String message) {
        this.message = message;
        return this;
    }

    public MongoDbErrorType type() {
        return this.type;
    }

    public MongoDbError withType(MongoDbErrorType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDbError fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbError)jsonReader.readObject(reader -> {
            MongoDbError deserializedMongoDbError = new MongoDbError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedMongoDbError.code = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    deserializedMongoDbError.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMongoDbError.message = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbError.type = MongoDbErrorType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbError;
        });
    }
}

