/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AuthenticationType;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import java.io.IOException;

public final class MongoDbConnectionInfo
extends ConnectionInfo {
    private String type = "MongoDbConnectionInfo";
    private String connectionString;
    private String dataSource;
    private Boolean encryptConnection;
    private String serverBrandVersion;
    private String serverVersion;
    private String serverName;
    private Boolean trustServerCertificate;
    private Boolean enforceSsl;
    private Integer port;
    private String additionalSettings;
    private AuthenticationType authentication;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbConnectionInfo.class);

    @Override
    public String type() {
        return this.type;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public MongoDbConnectionInfo withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String dataSource() {
        return this.dataSource;
    }

    public MongoDbConnectionInfo withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public Boolean encryptConnection() {
        return this.encryptConnection;
    }

    public MongoDbConnectionInfo withEncryptConnection(Boolean encryptConnection) {
        this.encryptConnection = encryptConnection;
        return this;
    }

    public String serverBrandVersion() {
        return this.serverBrandVersion;
    }

    public MongoDbConnectionInfo withServerBrandVersion(String serverBrandVersion) {
        this.serverBrandVersion = serverBrandVersion;
        return this;
    }

    public String serverVersion() {
        return this.serverVersion;
    }

    public MongoDbConnectionInfo withServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public String serverName() {
        return this.serverName;
    }

    public MongoDbConnectionInfo withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public Boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    public MongoDbConnectionInfo withTrustServerCertificate(Boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public Boolean enforceSsl() {
        return this.enforceSsl;
    }

    public MongoDbConnectionInfo withEnforceSsl(Boolean enforceSsl) {
        this.enforceSsl = enforceSsl;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public MongoDbConnectionInfo withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String additionalSettings() {
        return this.additionalSettings;
    }

    public MongoDbConnectionInfo withAdditionalSettings(String additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    public AuthenticationType authentication() {
        return this.authentication;
    }

    public MongoDbConnectionInfo withAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public MongoDbConnectionInfo withUsername(String username) {
        super.withUsername(username);
        return this;
    }

    @Override
    public MongoDbConnectionInfo withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.connectionString() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionString in model MongoDbConnectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username());
        jsonWriter.writeStringField("password", this.password());
        jsonWriter.writeStringField("connectionString", this.connectionString);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeBooleanField("encryptConnection", this.encryptConnection);
        jsonWriter.writeStringField("serverBrandVersion", this.serverBrandVersion);
        jsonWriter.writeStringField("serverVersion", this.serverVersion);
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeBooleanField("trustServerCertificate", this.trustServerCertificate);
        jsonWriter.writeBooleanField("enforceSSL", this.enforceSsl);
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("additionalSettings", this.additionalSettings);
        jsonWriter.writeStringField("authentication", this.authentication == null ? null : this.authentication.toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDbConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbConnectionInfo)jsonReader.readObject(reader -> {
            MongoDbConnectionInfo deserializedMongoDbConnectionInfo = new MongoDbConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.withUsername(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.withPassword(reader.getString());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.connectionString = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.type = reader.getString();
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.dataSource = reader.getString();
                    continue;
                }
                if ("encryptConnection".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.encryptConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("serverBrandVersion".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.serverBrandVersion = reader.getString();
                    continue;
                }
                if ("serverVersion".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.serverVersion = reader.getString();
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.serverName = reader.getString();
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.trustServerCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enforceSSL".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.enforceSsl = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("additionalSettings".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.additionalSettings = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedMongoDbConnectionInfo.authentication = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbConnectionInfo;
        });
    }
}

