/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbShardKeySetting;
import java.io.IOException;

public final class MongoDbCollectionSettings
implements JsonSerializable<MongoDbCollectionSettings> {
    private Boolean canDelete;
    private MongoDbShardKeySetting shardKey;
    private Integer targetRUs;

    public Boolean canDelete() {
        return this.canDelete;
    }

    public MongoDbCollectionSettings withCanDelete(Boolean canDelete) {
        this.canDelete = canDelete;
        return this;
    }

    public MongoDbShardKeySetting shardKey() {
        return this.shardKey;
    }

    public MongoDbCollectionSettings withShardKey(MongoDbShardKeySetting shardKey) {
        this.shardKey = shardKey;
        return this;
    }

    public Integer targetRUs() {
        return this.targetRUs;
    }

    public MongoDbCollectionSettings withTargetRUs(Integer targetRUs) {
        this.targetRUs = targetRUs;
        return this;
    }

    public void validate() {
        if (this.shardKey() != null) {
            this.shardKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("canDelete", this.canDelete);
        jsonWriter.writeJsonField("shardKey", (JsonSerializable)this.shardKey);
        jsonWriter.writeNumberField("targetRUs", (Number)this.targetRUs);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbCollectionSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbCollectionSettings)jsonReader.readObject(reader -> {
            MongoDbCollectionSettings deserializedMongoDbCollectionSettings = new MongoDbCollectionSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("canDelete".equals(fieldName)) {
                    deserializedMongoDbCollectionSettings.canDelete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("shardKey".equals(fieldName)) {
                    deserializedMongoDbCollectionSettings.shardKey = MongoDbShardKeySetting.fromJson(reader);
                    continue;
                }
                if ("targetRUs".equals(fieldName)) {
                    deserializedMongoDbCollectionSettings.targetRUs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbCollectionSettings;
        });
    }
}

