/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbObjectInfo;
import com.azure.resourcemanager.datamigration.models.MongoDbShardKeyInfo;
import java.io.IOException;

public final class MongoDbCollectionInfo
extends MongoDbObjectInfo {
    private String databaseName;
    private boolean isCapped;
    private boolean isSystemCollection;
    private boolean isView;
    private MongoDbShardKeyInfo shardKey;
    private boolean supportsSharding;
    private String viewOf;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbCollectionInfo.class);

    public String databaseName() {
        return this.databaseName;
    }

    public MongoDbCollectionInfo withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public boolean isCapped() {
        return this.isCapped;
    }

    public MongoDbCollectionInfo withIsCapped(boolean isCapped) {
        this.isCapped = isCapped;
        return this;
    }

    public boolean isSystemCollection() {
        return this.isSystemCollection;
    }

    public MongoDbCollectionInfo withIsSystemCollection(boolean isSystemCollection) {
        this.isSystemCollection = isSystemCollection;
        return this;
    }

    public boolean isView() {
        return this.isView;
    }

    public MongoDbCollectionInfo withIsView(boolean isView) {
        this.isView = isView;
        return this;
    }

    public MongoDbShardKeyInfo shardKey() {
        return this.shardKey;
    }

    public MongoDbCollectionInfo withShardKey(MongoDbShardKeyInfo shardKey) {
        this.shardKey = shardKey;
        return this;
    }

    public boolean supportsSharding() {
        return this.supportsSharding;
    }

    public MongoDbCollectionInfo withSupportsSharding(boolean supportsSharding) {
        this.supportsSharding = supportsSharding;
        return this;
    }

    public String viewOf() {
        return this.viewOf;
    }

    public MongoDbCollectionInfo withViewOf(String viewOf) {
        this.viewOf = viewOf;
        return this;
    }

    @Override
    public MongoDbCollectionInfo withAverageDocumentSize(long averageDocumentSize) {
        super.withAverageDocumentSize(averageDocumentSize);
        return this;
    }

    @Override
    public MongoDbCollectionInfo withDataSize(long dataSize) {
        super.withDataSize(dataSize);
        return this;
    }

    @Override
    public MongoDbCollectionInfo withDocumentCount(long documentCount) {
        super.withDocumentCount(documentCount);
        return this;
    }

    @Override
    public MongoDbCollectionInfo withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MongoDbCollectionInfo withQualifiedName(String qualifiedName) {
        super.withQualifiedName(qualifiedName);
        return this;
    }

    @Override
    public void validate() {
        if (this.databaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model MongoDbCollectionInfo"));
        }
        if (this.shardKey() != null) {
            this.shardKey().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MongoDbCollectionInfo"));
        }
        if (this.qualifiedName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property qualifiedName in model MongoDbCollectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("averageDocumentSize", this.averageDocumentSize());
        jsonWriter.writeLongField("dataSize", this.dataSize());
        jsonWriter.writeLongField("documentCount", this.documentCount());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName());
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeBooleanField("isCapped", this.isCapped);
        jsonWriter.writeBooleanField("isSystemCollection", this.isSystemCollection);
        jsonWriter.writeBooleanField("isView", this.isView);
        jsonWriter.writeBooleanField("supportsSharding", this.supportsSharding);
        jsonWriter.writeJsonField("shardKey", (JsonSerializable)this.shardKey);
        jsonWriter.writeStringField("viewOf", this.viewOf);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbCollectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbCollectionInfo)jsonReader.readObject(reader -> {
            MongoDbCollectionInfo deserializedMongoDbCollectionInfo = new MongoDbCollectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("averageDocumentSize".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.withAverageDocumentSize(reader.getLong());
                    continue;
                }
                if ("dataSize".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.withDataSize(reader.getLong());
                    continue;
                }
                if ("documentCount".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.withDocumentCount(reader.getLong());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.withName(reader.getString());
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.withQualifiedName(reader.getString());
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.databaseName = reader.getString();
                    continue;
                }
                if ("isCapped".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.isCapped = reader.getBoolean();
                    continue;
                }
                if ("isSystemCollection".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.isSystemCollection = reader.getBoolean();
                    continue;
                }
                if ("isView".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.isView = reader.getBoolean();
                    continue;
                }
                if ("supportsSharding".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.supportsSharding = reader.getBoolean();
                    continue;
                }
                if ("shardKey".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.shardKey = MongoDbShardKeyInfo.fromJson(reader);
                    continue;
                }
                if ("viewOf".equals(fieldName)) {
                    deserializedMongoDbCollectionInfo.viewOf = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbCollectionInfo;
        });
    }
}

