/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbClusterType;
import com.azure.resourcemanager.datamigration.models.MongoDbDatabaseInfo;
import java.io.IOException;
import java.util.List;

public final class MongoDbClusterInfo
implements JsonSerializable<MongoDbClusterInfo> {
    private List<MongoDbDatabaseInfo> databases;
    private boolean supportsSharding;
    private MongoDbClusterType type;
    private String version;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbClusterInfo.class);

    public List<MongoDbDatabaseInfo> databases() {
        return this.databases;
    }

    public MongoDbClusterInfo withDatabases(List<MongoDbDatabaseInfo> databases) {
        this.databases = databases;
        return this;
    }

    public boolean supportsSharding() {
        return this.supportsSharding;
    }

    public MongoDbClusterInfo withSupportsSharding(boolean supportsSharding) {
        this.supportsSharding = supportsSharding;
        return this;
    }

    public MongoDbClusterType type() {
        return this.type;
    }

    public MongoDbClusterInfo withType(MongoDbClusterType type) {
        this.type = type;
        return this;
    }

    public String version() {
        return this.version;
    }

    public MongoDbClusterInfo withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.databases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databases in model MongoDbClusterInfo"));
        }
        this.databases().forEach(e -> e.validate());
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model MongoDbClusterInfo"));
        }
        if (this.version() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property version in model MongoDbClusterInfo"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("supportsSharding", this.supportsSharding);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbClusterInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbClusterInfo)jsonReader.readObject(reader -> {
            MongoDbClusterInfo deserializedMongoDbClusterInfo = new MongoDbClusterInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databases".equals(fieldName)) {
                    List databases;
                    deserializedMongoDbClusterInfo.databases = databases = reader.readArray(reader1 -> MongoDbDatabaseInfo.fromJson(reader1));
                    continue;
                }
                if ("supportsSharding".equals(fieldName)) {
                    deserializedMongoDbClusterInfo.supportsSharding = reader.getBoolean();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbClusterInfo.type = MongoDbClusterType.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMongoDbClusterInfo.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbClusterInfo;
        });
    }
}

