/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MongoConnectionInformation
implements JsonSerializable<MongoConnectionInformation> {
    private String host;
    private Integer port;
    private String username;
    private String password;
    private Boolean useSsl;
    private String connectionString;

    public String host() {
        return this.host;
    }

    public MongoConnectionInformation withHost(String host) {
        this.host = host;
        return this;
    }

    public Integer port() {
        return this.port;
    }

    public MongoConnectionInformation withPort(Integer port) {
        this.port = port;
        return this;
    }

    public String username() {
        return this.username;
    }

    public MongoConnectionInformation withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public MongoConnectionInformation withPassword(String password) {
        this.password = password;
        return this;
    }

    public Boolean useSsl() {
        return this.useSsl;
    }

    public MongoConnectionInformation withUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
        return this;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public MongoConnectionInformation withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeNumberField("port", (Number)this.port);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeBooleanField("useSsl", this.useSsl);
        jsonWriter.writeStringField("connectionString", this.connectionString);
        return jsonWriter.writeEndObject();
    }

    public static MongoConnectionInformation fromJson(JsonReader jsonReader) throws IOException {
        return (MongoConnectionInformation)jsonReader.readObject(reader -> {
            MongoConnectionInformation deserializedMongoConnectionInformation = new MongoConnectionInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedMongoConnectionInformation.host = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMongoConnectionInformation.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedMongoConnectionInformation.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMongoConnectionInformation.password = reader.getString();
                    continue;
                }
                if ("useSsl".equals(fieldName)) {
                    deserializedMongoConnectionInformation.useSsl = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedMongoConnectionInformation.connectionString = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoConnectionInformation;
        });
    }
}

