/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ValidationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrationValidationDatabaseSummaryResult
implements JsonSerializable<MigrationValidationDatabaseSummaryResult> {
    private String id;
    private String migrationId;
    private String sourceDatabaseName;
    private String targetDatabaseName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private ValidationStatus status;

    public String id() {
        return this.id;
    }

    public String migrationId() {
        return this.migrationId;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public ValidationStatus status() {
        return this.status;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MigrationValidationDatabaseSummaryResult fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationValidationDatabaseSummaryResult)jsonReader.readObject(reader -> {
            MigrationValidationDatabaseSummaryResult deserializedMigrationValidationDatabaseSummaryResult = new MigrationValidationDatabaseSummaryResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.id = reader.getString();
                    continue;
                }
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.migrationId = reader.getString();
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.sourceDatabaseName = reader.getString();
                    continue;
                }
                if ("targetDatabaseName".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.targetDatabaseName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseSummaryResult.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationValidationDatabaseSummaryResult;
        });
    }
}

