/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.LoginMigrationStage;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSqlServerSqlMITaskOutputLoginLevel
extends MigrateSqlServerSqlMITaskOutput {
    private String resultType = "LoginLevelOutput";
    private String loginName;
    private MigrationState state;
    private LoginMigrationStage stage;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String message;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String loginName() {
        return this.loginName;
    }

    public MigrationState state() {
        return this.state;
    }

    public LoginMigrationStage stage() {
        return this.stage;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String message() {
        return this.message;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMITaskOutputLoginLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMITaskOutputLoginLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMITaskOutputLoginLevel deserializedMigrateSqlServerSqlMITaskOutputLoginLevel = new MigrateSqlServerSqlMITaskOutputLoginLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.resultType = reader.getString();
                    continue;
                }
                if ("loginName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.loginName = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.stage = LoginMigrationStage.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.message = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSqlServerSqlMITaskOutputLoginLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMITaskOutputLoginLevel;
        });
    }
}

