/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupSetInfo;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationState;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMISyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel
extends MigrateSqlServerSqlMISyncTaskOutput {
    private String resultType = "DatabaseLevelOutput";
    private String sourceDatabaseName;
    private DatabaseMigrationState migrationState;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private BackupSetInfo fullBackupSetInfo;
    private BackupSetInfo lastRestoredBackupSetInfo;
    private List<BackupSetInfo> activeBackupSets;
    private String containerName;
    private String errorPrefix;
    private Boolean isFullBackupRestored;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public DatabaseMigrationState migrationState() {
        return this.migrationState;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public BackupSetInfo fullBackupSetInfo() {
        return this.fullBackupSetInfo;
    }

    public BackupSetInfo lastRestoredBackupSetInfo() {
        return this.lastRestoredBackupSetInfo;
    }

    public List<BackupSetInfo> activeBackupSets() {
        return this.activeBackupSets;
    }

    public String containerName() {
        return this.containerName;
    }

    public String errorPrefix() {
        return this.errorPrefix;
    }

    public Boolean isFullBackupRestored() {
        return this.isFullBackupRestored;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.fullBackupSetInfo() != null) {
            this.fullBackupSetInfo().validate();
        }
        if (this.lastRestoredBackupSetInfo() != null) {
            this.lastRestoredBackupSetInfo().validate();
        }
        if (this.activeBackupSets() != null) {
            this.activeBackupSets().forEach(e -> e.validate());
        }
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel = new MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.resultType = reader.getString();
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.sourceDatabaseName = reader.getString();
                    continue;
                }
                if ("migrationState".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.migrationState = DatabaseMigrationState.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fullBackupSetInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.fullBackupSetInfo = BackupSetInfo.fromJson(reader);
                    continue;
                }
                if ("lastRestoredBackupSetInfo".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.lastRestoredBackupSetInfo = BackupSetInfo.fromJson(reader);
                    continue;
                }
                if ("activeBackupSets".equals(fieldName)) {
                    List activeBackupSets;
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.activeBackupSets = activeBackupSets = reader.readArray(reader1 -> BackupSetInfo.fromJson(reader1));
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.containerName = reader.getString();
                    continue;
                }
                if ("errorPrefix".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.errorPrefix = reader.getString();
                    continue;
                }
                if ("isFullBackupRestored".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.isFullBackupRestored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMISyncTaskOutputDatabaseLevel;
        });
    }
}

