/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationReportResult;
import com.azure.resourcemanager.datamigration.models.MigrationStatus;
import com.azure.resourcemanager.datamigration.models.MigrationValidationResult;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSqlServerSqlDbTaskOutputMigrationLevel
extends MigrateSqlServerSqlDbTaskOutput {
    private String resultType = "MigrationLevelOutput";
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private Long durationInSeconds;
    private MigrationStatus status;
    private String statusMessage;
    private String message;
    private String databases;
    private String databaseSummary;
    private MigrationValidationResult migrationValidationResult;
    private MigrationReportResult migrationReportResult;
    private String sourceServerVersion;
    private String sourceServerBrandVersion;
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public Long durationInSeconds() {
        return this.durationInSeconds;
    }

    public MigrationStatus status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String message() {
        return this.message;
    }

    public String databases() {
        return this.databases;
    }

    public String databaseSummary() {
        return this.databaseSummary;
    }

    public MigrationValidationResult migrationValidationResult() {
        return this.migrationValidationResult;
    }

    public MigrateSqlServerSqlDbTaskOutputMigrationLevel withMigrationValidationResult(MigrationValidationResult migrationValidationResult) {
        this.migrationValidationResult = migrationValidationResult;
        return this;
    }

    public MigrationReportResult migrationReportResult() {
        return this.migrationReportResult;
    }

    public MigrateSqlServerSqlDbTaskOutputMigrationLevel withMigrationReportResult(MigrationReportResult migrationReportResult) {
        this.migrationReportResult = migrationReportResult;
        return this;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.migrationValidationResult() != null) {
            this.migrationValidationResult().validate();
        }
        if (this.migrationReportResult() != null) {
            this.migrationReportResult().validate();
        }
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeJsonField("migrationValidationResult", (JsonSerializable)this.migrationValidationResult);
        jsonWriter.writeJsonField("migrationReportResult", (JsonSerializable)this.migrationReportResult);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbTaskOutputMigrationLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbTaskOutputMigrationLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbTaskOutputMigrationLevel deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel = new MigrateSqlServerSqlDbTaskOutputMigrationLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.resultType = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInSeconds".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.durationInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.status = MigrationStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.statusMessage = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.message = reader.getString();
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.databases = reader.getString();
                    continue;
                }
                if ("databaseSummary".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.databaseSummary = reader.getString();
                    continue;
                }
                if ("migrationValidationResult".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.migrationValidationResult = MigrationValidationResult.fromJson(reader);
                    continue;
                }
                if ("migrationReportResult".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.migrationReportResult = MigrationReportResult.fromJson(reader);
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbTaskOutputMigrationLevel;
        });
    }
}

