/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbSyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.SyncDatabaseMigrationReportingState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel
extends MigrateSqlServerSqlDbSyncTaskOutput {
    private String resultType = "DatabaseLevelOutput";
    private String databaseName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private SyncDatabaseMigrationReportingState migrationState;
    private Long incomingChanges;
    private Long appliedChanges;
    private Long cdcInsertCounter;
    private Long cdcDeleteCounter;
    private Long cdcUpdateCounter;
    private Long fullLoadCompletedTables;
    private Long fullLoadLoadingTables;
    private Long fullLoadQueuedTables;
    private Long fullLoadErroredTables;
    private Boolean initializationCompleted;
    private Long latency;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public SyncDatabaseMigrationReportingState migrationState() {
        return this.migrationState;
    }

    public Long incomingChanges() {
        return this.incomingChanges;
    }

    public Long appliedChanges() {
        return this.appliedChanges;
    }

    public Long cdcInsertCounter() {
        return this.cdcInsertCounter;
    }

    public Long cdcDeleteCounter() {
        return this.cdcDeleteCounter;
    }

    public Long cdcUpdateCounter() {
        return this.cdcUpdateCounter;
    }

    public Long fullLoadCompletedTables() {
        return this.fullLoadCompletedTables;
    }

    public Long fullLoadLoadingTables() {
        return this.fullLoadLoadingTables;
    }

    public Long fullLoadQueuedTables() {
        return this.fullLoadQueuedTables;
    }

    public Long fullLoadErroredTables() {
        return this.fullLoadErroredTables;
    }

    public Boolean initializationCompleted() {
        return this.initializationCompleted;
    }

    public Long latency() {
        return this.latency;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel = new MigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.resultType = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.databaseName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrationState".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.migrationState = SyncDatabaseMigrationReportingState.fromString(reader.getString());
                    continue;
                }
                if ("incomingChanges".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.incomingChanges = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("appliedChanges".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.appliedChanges = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cdcInsertCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.cdcInsertCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cdcDeleteCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.cdcDeleteCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("cdcUpdateCounter".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.cdcUpdateCounter = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fullLoadCompletedTables".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.fullLoadCompletedTables = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fullLoadLoadingTables".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.fullLoadLoadingTables = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fullLoadQueuedTables".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.fullLoadQueuedTables = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fullLoadErroredTables".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.fullLoadErroredTables = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("initializationCompleted".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.initializationCompleted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("latency".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel.latency = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbSyncTaskOutputDatabaseLevel;
        });
    }
}

