/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSchemaSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.SchemaMigrationStage;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel
extends MigrateSchemaSqlServerSqlDbTaskOutput {
    private String resultType = "DatabaseLevelOutput";
    private String databaseName;
    private MigrationState state;
    private SchemaMigrationStage stage;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String databaseErrorResultPrefix;
    private String schemaErrorResultPrefix;
    private Long numberOfSuccessfulOperations;
    private Long numberOfFailedOperations;
    private String fileId;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public MigrationState state() {
        return this.state;
    }

    public SchemaMigrationStage stage() {
        return this.stage;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String databaseErrorResultPrefix() {
        return this.databaseErrorResultPrefix;
    }

    public String schemaErrorResultPrefix() {
        return this.schemaErrorResultPrefix;
    }

    public Long numberOfSuccessfulOperations() {
        return this.numberOfSuccessfulOperations;
    }

    public Long numberOfFailedOperations() {
        return this.numberOfFailedOperations;
    }

    public String fileId() {
        return this.fileId;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel)jsonReader.readObject(reader -> {
            MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel = new MigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.resultType = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.databaseName = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.stage = SchemaMigrationStage.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("databaseErrorResultPrefix".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.databaseErrorResultPrefix = reader.getString();
                    continue;
                }
                if ("schemaErrorResultPrefix".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.schemaErrorResultPrefix = reader.getString();
                    continue;
                }
                if ("numberOfSuccessfulOperations".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.numberOfSuccessfulOperations = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("numberOfFailedOperations".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.numberOfFailedOperations = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("fileId".equals(fieldName)) {
                    deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel.fileId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSchemaSqlServerSqlDbTaskOutputDatabaseLevel;
        });
    }
}

