/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput;
import com.azure.resourcemanager.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.MIGRATE_POSTGRE_SQL_AZURE_DB_FOR_POSTGRE_SQL_SYNC_V2;
    private MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput input;
    private List<MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput> output;
    private String taskId;
    private String createdOn;
    private Boolean isCloneable;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput input() {
        return this.input;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties withInput(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput input) {
        this.input = input;
        return this;
    }

    public List<MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput> output() {
        return this.output;
    }

    public String taskId() {
        return this.taskId;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String createdOn() {
        return this.createdOn;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties withCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public Boolean isCloneable() {
        return this.isCloneable;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties withIsCloneable(Boolean isCloneable) {
        this.isCloneable = isCloneable;
        return this;
    }

    @Override
    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("taskId", this.taskId);
        jsonWriter.writeStringField("createdOn", this.createdOn);
        jsonWriter.writeBooleanField("isCloneable", this.isCloneable);
        return jsonWriter.writeEndObject();
    }

    public static MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties)jsonReader.readObject(reader -> {
            MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties = new MigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.input = MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.output = output = reader.readArray(reader1 -> MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput.fromJson(reader1));
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.taskId = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.createdOn = reader.getString();
                    continue;
                }
                if ("isCloneable".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties.isCloneable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskProperties;
        });
    }
}

