/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput;
import com.azure.resourcemanager.datamigration.models.ReplicateMigrationState;
import com.azure.resourcemanager.datamigration.models.ScenarioSource;
import com.azure.resourcemanager.datamigration.models.ScenarioTarget;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel
extends MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutput {
    private String resultType = "MigrationLevelOutput";
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String sourceServerVersion;
    private String sourceServer;
    private String targetServerVersion;
    private String targetServer;
    private ScenarioSource sourceServerType;
    private ScenarioTarget targetServerType;
    private ReplicateMigrationState state;
    private Float databaseCount;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServer() {
        return this.sourceServer;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServer() {
        return this.targetServer;
    }

    public ScenarioSource sourceServerType() {
        return this.sourceServerType;
    }

    public ScenarioTarget targetServerType() {
        return this.targetServerType;
    }

    public ReplicateMigrationState state() {
        return this.state;
    }

    public Float databaseCount() {
        return this.databaseCount;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel withDatabaseCount(Float databaseCount) {
        this.databaseCount = databaseCount;
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeNumberField("databaseCount", (Number)this.databaseCount);
        return jsonWriter.writeEndObject();
    }

    public static MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel)jsonReader.readObject(reader -> {
            MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel = new MigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.resultType = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServer".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.sourceServer = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServer".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.targetServer = reader.getString();
                    continue;
                }
                if ("sourceServerType".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.sourceServerType = ScenarioSource.fromString(reader.getString());
                    continue;
                }
                if ("targetServerType".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.targetServerType = ScenarioTarget.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.state = ReplicateMigrationState.fromString(reader.getString());
                    continue;
                }
                if ("databaseCount".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel.databaseCount = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskOutputMigrationLevel;
        });
    }
}

