/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateMySqlAzureDbForMySqlSyncDatabaseInput;
import com.azure.resourcemanager.datamigration.models.MySqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class MigrateMySqlAzureDbForMySqlSyncTaskInput
implements JsonSerializable<MigrateMySqlAzureDbForMySqlSyncTaskInput> {
    private MySqlConnectionInfo sourceConnectionInfo;
    private MySqlConnectionInfo targetConnectionInfo;
    private List<MigrateMySqlAzureDbForMySqlSyncDatabaseInput> selectedDatabases;
    private static final ClientLogger LOGGER = new ClientLogger(MigrateMySqlAzureDbForMySqlSyncTaskInput.class);

    public MySqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public MigrateMySqlAzureDbForMySqlSyncTaskInput withSourceConnectionInfo(MySqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public MySqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public MigrateMySqlAzureDbForMySqlSyncTaskInput withTargetConnectionInfo(MySqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public List<MigrateMySqlAzureDbForMySqlSyncDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigrateMySqlAzureDbForMySqlSyncTaskInput withSelectedDatabases(List<MigrateMySqlAzureDbForMySqlSyncDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigrateMySqlAzureDbForMySqlSyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigrateMySqlAzureDbForMySqlSyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigrateMySqlAzureDbForMySqlSyncTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MigrateMySqlAzureDbForMySqlSyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateMySqlAzureDbForMySqlSyncTaskInput)jsonReader.readObject(reader -> {
            MigrateMySqlAzureDbForMySqlSyncTaskInput deserializedMigrateMySqlAzureDbForMySqlSyncTaskInput = new MigrateMySqlAzureDbForMySqlSyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlSyncTaskInput.sourceConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlSyncTaskInput.targetConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigrateMySqlAzureDbForMySqlSyncTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigrateMySqlAzureDbForMySqlSyncDatabaseInput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateMySqlAzureDbForMySqlSyncTaskInput;
        });
    }
}

