/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationReportResult;
import com.azure.resourcemanager.datamigration.models.MigrationStatus;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel
extends MigrateMySqlAzureDbForMySqlOfflineTaskOutput {
    private String resultType = "MigrationLevelOutput";
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private Long durationInSeconds;
    private MigrationStatus status;
    private String statusMessage;
    private String message;
    private String databases;
    private String databaseSummary;
    private MigrationReportResult migrationReportResult;
    private String sourceServerVersion;
    private String sourceServerBrandVersion;
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private List<ReportableException> exceptionsAndWarnings;
    private OffsetDateTime lastStorageUpdate;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public Long durationInSeconds() {
        return this.durationInSeconds;
    }

    public MigrationStatus status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String message() {
        return this.message;
    }

    public String databases() {
        return this.databases;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel withDatabases(String databases) {
        this.databases = databases;
        return this;
    }

    public String databaseSummary() {
        return this.databaseSummary;
    }

    public MigrationReportResult migrationReportResult() {
        return this.migrationReportResult;
    }

    public MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel withMigrationReportResult(MigrationReportResult migrationReportResult) {
        this.migrationReportResult = migrationReportResult;
        return this;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    public OffsetDateTime lastStorageUpdate() {
        return this.lastStorageUpdate;
    }

    @Override
    public void validate() {
        if (this.migrationReportResult() != null) {
            this.migrationReportResult().validate();
        }
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeStringField("databases", this.databases);
        jsonWriter.writeJsonField("migrationReportResult", (JsonSerializable)this.migrationReportResult);
        return jsonWriter.writeEndObject();
    }

    public static MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel)jsonReader.readObject(reader -> {
            MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel = new MigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.resultType = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInSeconds".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.durationInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.status = MigrationStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.statusMessage = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.message = reader.getString();
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.databases = reader.getString();
                    continue;
                }
                if ("databaseSummary".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.databaseSummary = reader.getString();
                    continue;
                }
                if ("migrationReportResult".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.migrationReportResult = MigrationReportResult.fromJson(reader);
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("lastStorageUpdate".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel.lastStorageUpdate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputMigrationLevel;
        });
    }
}

