/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationStage;
import com.azure.resourcemanager.datamigration.models.MigrateMySqlAzureDbForMySqlOfflineTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel
extends MigrateMySqlAzureDbForMySqlOfflineTaskOutput {
    private String resultType = "DatabaseLevelOutput";
    private String databaseName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private MigrationState state;
    private DatabaseMigrationStage stage;
    private String statusMessage;
    private String message;
    private Long numberOfObjects;
    private Long numberOfObjectsCompleted;
    private Long errorCount;
    private String errorPrefix;
    private String resultPrefix;
    private List<ReportableException> exceptionsAndWarnings;
    private OffsetDateTime lastStorageUpdate;
    private String objectSummary;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public MigrationState state() {
        return this.state;
    }

    public DatabaseMigrationStage stage() {
        return this.stage;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String message() {
        return this.message;
    }

    public Long numberOfObjects() {
        return this.numberOfObjects;
    }

    public Long numberOfObjectsCompleted() {
        return this.numberOfObjectsCompleted;
    }

    public Long errorCount() {
        return this.errorCount;
    }

    public String errorPrefix() {
        return this.errorPrefix;
    }

    public String resultPrefix() {
        return this.resultPrefix;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    public OffsetDateTime lastStorageUpdate() {
        return this.lastStorageUpdate;
    }

    public String objectSummary() {
        return this.objectSummary;
    }

    @Override
    public void validate() {
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel)jsonReader.readObject(reader -> {
            MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel = new MigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.resultType = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.databaseName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.stage = DatabaseMigrationStage.fromString(reader.getString());
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.statusMessage = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.message = reader.getString();
                    continue;
                }
                if ("numberOfObjects".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.numberOfObjects = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("numberOfObjectsCompleted".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.numberOfObjectsCompleted = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("errorCount".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.errorCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("errorPrefix".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.errorPrefix = reader.getString();
                    continue;
                }
                if ("resultPrefix".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.resultPrefix = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("lastStorageUpdate".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.lastStorageUpdate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("objectSummary".equals(fieldName)) {
                    deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel.objectSummary = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateMySqlAzureDbForMySqlOfflineTaskOutputDatabaseLevel;
        });
    }
}

