/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import java.io.IOException;

public final class MiSqlConnectionInfo
extends ConnectionInfo {
    private String type = "MiSqlConnectionInfo";
    private String managedInstanceResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(MiSqlConnectionInfo.class);

    @Override
    public String type() {
        return this.type;
    }

    public String managedInstanceResourceId() {
        return this.managedInstanceResourceId;
    }

    public MiSqlConnectionInfo withManagedInstanceResourceId(String managedInstanceResourceId) {
        this.managedInstanceResourceId = managedInstanceResourceId;
        return this;
    }

    @Override
    public MiSqlConnectionInfo withUsername(String username) {
        super.withUsername(username);
        return this;
    }

    @Override
    public MiSqlConnectionInfo withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.managedInstanceResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managedInstanceResourceId in model MiSqlConnectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username());
        jsonWriter.writeStringField("password", this.password());
        jsonWriter.writeStringField("managedInstanceResourceId", this.managedInstanceResourceId);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MiSqlConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MiSqlConnectionInfo)jsonReader.readObject(reader -> {
            MiSqlConnectionInfo deserializedMiSqlConnectionInfo = new MiSqlConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedMiSqlConnectionInfo.withUsername(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMiSqlConnectionInfo.withPassword(reader.getString());
                    continue;
                }
                if ("managedInstanceResourceId".equals(fieldName)) {
                    deserializedMiSqlConnectionInfo.managedInstanceResourceId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMiSqlConnectionInfo.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMiSqlConnectionInfo;
        });
    }
}

