/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesSqlSyncTaskInput
implements JsonSerializable<GetUserTablesSqlSyncTaskInput> {
    private SqlConnectionInfo sourceConnectionInfo;
    private SqlConnectionInfo targetConnectionInfo;
    private List<String> selectedSourceDatabases;
    private List<String> selectedTargetDatabases;
    private static final ClientLogger LOGGER = new ClientLogger(GetUserTablesSqlSyncTaskInput.class);

    public SqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public GetUserTablesSqlSyncTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public SqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public GetUserTablesSqlSyncTaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public List<String> selectedSourceDatabases() {
        return this.selectedSourceDatabases;
    }

    public GetUserTablesSqlSyncTaskInput withSelectedSourceDatabases(List<String> selectedSourceDatabases) {
        this.selectedSourceDatabases = selectedSourceDatabases;
        return this;
    }

    public List<String> selectedTargetDatabases() {
        return this.selectedTargetDatabases;
    }

    public GetUserTablesSqlSyncTaskInput withSelectedTargetDatabases(List<String> selectedTargetDatabases) {
        this.selectedTargetDatabases = selectedTargetDatabases;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model GetUserTablesSqlSyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model GetUserTablesSqlSyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.selectedSourceDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedSourceDatabases in model GetUserTablesSqlSyncTaskInput"));
        }
        if (this.selectedTargetDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedTargetDatabases in model GetUserTablesSqlSyncTaskInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeArrayField("selectedSourceDatabases", this.selectedSourceDatabases, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("selectedTargetDatabases", this.selectedTargetDatabases, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesSqlSyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesSqlSyncTaskInput)jsonReader.readObject(reader -> {
            GetUserTablesSqlSyncTaskInput deserializedGetUserTablesSqlSyncTaskInput = new GetUserTablesSqlSyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedGetUserTablesSqlSyncTaskInput.sourceConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedGetUserTablesSqlSyncTaskInput.targetConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedSourceDatabases".equals(fieldName)) {
                    List selectedSourceDatabases;
                    deserializedGetUserTablesSqlSyncTaskInput.selectedSourceDatabases = selectedSourceDatabases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("selectedTargetDatabases".equals(fieldName)) {
                    List selectedTargetDatabases;
                    deserializedGetUserTablesSqlSyncTaskInput.selectedTargetDatabases = selectedTargetDatabases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesSqlSyncTaskInput;
        });
    }
}

