/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseTable;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesPostgreSqlTaskOutput
implements JsonSerializable<GetUserTablesPostgreSqlTaskOutput> {
    private String databaseName;
    private List<DatabaseTable> tables;
    private List<ReportableException> validationErrors;

    public String databaseName() {
        return this.databaseName;
    }

    public List<DatabaseTable> tables() {
        return this.tables;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.tables() != null) {
            this.tables().forEach(e -> e.validate());
        }
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesPostgreSqlTaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesPostgreSqlTaskOutput)jsonReader.readObject(reader -> {
            GetUserTablesPostgreSqlTaskOutput deserializedGetUserTablesPostgreSqlTaskOutput = new GetUserTablesPostgreSqlTaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedGetUserTablesPostgreSqlTaskOutput.databaseName = reader.getString();
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    List tables;
                    deserializedGetUserTablesPostgreSqlTaskOutput.tables = tables = reader.readArray(reader1 -> DatabaseTable.fromJson(reader1));
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedGetUserTablesPostgreSqlTaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesPostgreSqlTaskOutput;
        });
    }
}

