/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseTable;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesOracleTaskOutput
implements JsonSerializable<GetUserTablesOracleTaskOutput> {
    private String schemaName;
    private List<DatabaseTable> tables;
    private List<ReportableException> validationErrors;

    public String schemaName() {
        return this.schemaName;
    }

    public List<DatabaseTable> tables() {
        return this.tables;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.tables() != null) {
            this.tables().forEach(e -> e.validate());
        }
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesOracleTaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesOracleTaskOutput)jsonReader.readObject(reader -> {
            GetUserTablesOracleTaskOutput deserializedGetUserTablesOracleTaskOutput = new GetUserTablesOracleTaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaName".equals(fieldName)) {
                    deserializedGetUserTablesOracleTaskOutput.schemaName = reader.getString();
                    continue;
                }
                if ("tables".equals(fieldName)) {
                    List tables;
                    deserializedGetUserTablesOracleTaskOutput.tables = tables = reader.readArray(reader1 -> DatabaseTable.fromJson(reader1));
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedGetUserTablesOracleTaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesOracleTaskOutput;
        });
    }
}

