/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.OracleConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesOracleTaskInput
implements JsonSerializable<GetUserTablesOracleTaskInput> {
    private OracleConnectionInfo connectionInfo;
    private List<String> selectedSchemas;
    private static final ClientLogger LOGGER = new ClientLogger(GetUserTablesOracleTaskInput.class);

    public OracleConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public GetUserTablesOracleTaskInput withConnectionInfo(OracleConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    public List<String> selectedSchemas() {
        return this.selectedSchemas;
    }

    public GetUserTablesOracleTaskInput withSelectedSchemas(List<String> selectedSchemas) {
        this.selectedSchemas = selectedSchemas;
        return this;
    }

    public void validate() {
        if (this.connectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionInfo in model GetUserTablesOracleTaskInput"));
        }
        this.connectionInfo().validate();
        if (this.selectedSchemas() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedSchemas in model GetUserTablesOracleTaskInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionInfo", (JsonSerializable)this.connectionInfo);
        jsonWriter.writeArrayField("selectedSchemas", this.selectedSchemas, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesOracleTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesOracleTaskInput)jsonReader.readObject(reader -> {
            GetUserTablesOracleTaskInput deserializedGetUserTablesOracleTaskInput = new GetUserTablesOracleTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionInfo".equals(fieldName)) {
                    deserializedGetUserTablesOracleTaskInput.connectionInfo = OracleConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedSchemas".equals(fieldName)) {
                    List selectedSchemas;
                    deserializedGetUserTablesOracleTaskInput.selectedSchemas = selectedSchemas = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesOracleTaskInput;
        });
    }
}

