/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectFileInner;
import java.io.IOException;
import java.util.List;

public final class FileList
implements JsonSerializable<FileList> {
    private List<ProjectFileInner> value;
    private String nextLink;

    public List<ProjectFileInner> value() {
        return this.value;
    }

    public FileList withValue(List<ProjectFileInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public FileList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static FileList fromJson(JsonReader jsonReader) throws IOException {
        return (FileList)jsonReader.readObject(reader -> {
            FileList deserializedFileList = new FileList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedFileList.value = value = reader.readArray(reader1 -> ProjectFileInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedFileList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileList;
        });
    }
}

