/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupConfiguration;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationProperties;
import com.azure.resourcemanager.datamigration.models.ErrorInfo;
import com.azure.resourcemanager.datamigration.models.MigrationStatusDetails;
import com.azure.resourcemanager.datamigration.models.OfflineConfiguration;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import com.azure.resourcemanager.datamigration.models.ResourceType;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInformation;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DatabaseMigrationPropertiesSqlVm
extends DatabaseMigrationProperties {
    private ResourceType kind = ResourceType.SQL_VM;
    private MigrationStatusDetails migrationStatusDetails;
    private BackupConfiguration backupConfiguration;
    private OfflineConfiguration offlineConfiguration;

    @Override
    public ResourceType kind() {
        return this.kind;
    }

    public MigrationStatusDetails migrationStatusDetails() {
        return this.migrationStatusDetails;
    }

    public BackupConfiguration backupConfiguration() {
        return this.backupConfiguration;
    }

    public DatabaseMigrationPropertiesSqlVm withBackupConfiguration(BackupConfiguration backupConfiguration) {
        this.backupConfiguration = backupConfiguration;
        return this;
    }

    public OfflineConfiguration offlineConfiguration() {
        return this.offlineConfiguration;
    }

    public DatabaseMigrationPropertiesSqlVm withOfflineConfiguration(OfflineConfiguration offlineConfiguration) {
        this.offlineConfiguration = offlineConfiguration;
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withSourceSqlConnection(SqlConnectionInformation sourceSqlConnection) {
        super.withSourceSqlConnection(sourceSqlConnection);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withSourceDatabaseName(String sourceDatabaseName) {
        super.withSourceDatabaseName(sourceDatabaseName);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withTargetDatabaseCollation(String targetDatabaseCollation) {
        super.withTargetDatabaseCollation(targetDatabaseCollation);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withScope(String scope) {
        super.withScope(scope);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withMigrationService(String migrationService) {
        super.withMigrationService(migrationService);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withMigrationOperationId(String migrationOperationId) {
        super.withMigrationOperationId(migrationOperationId);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm withProvisioningError(String provisioningError) {
        super.withProvisioningError(provisioningError);
        return this;
    }

    @Override
    public void validate() {
        if (this.migrationStatusDetails() != null) {
            this.migrationStatusDetails().validate();
        }
        if (this.backupConfiguration() != null) {
            this.backupConfiguration().validate();
        }
        if (this.offlineConfiguration() != null) {
            this.offlineConfiguration().validate();
        }
        if (this.migrationFailureError() != null) {
            this.migrationFailureError().validate();
        }
        if (this.sourceSqlConnection() != null) {
            this.sourceSqlConnection().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope());
        jsonWriter.writeStringField("migrationService", this.migrationService());
        jsonWriter.writeStringField("migrationOperationId", this.migrationOperationId());
        jsonWriter.writeStringField("provisioningError", this.provisioningError());
        jsonWriter.writeJsonField("sourceSqlConnection", (JsonSerializable)this.sourceSqlConnection());
        jsonWriter.writeStringField("sourceDatabaseName", this.sourceDatabaseName());
        jsonWriter.writeStringField("targetDatabaseCollation", this.targetDatabaseCollation());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("backupConfiguration", (JsonSerializable)this.backupConfiguration);
        jsonWriter.writeJsonField("offlineConfiguration", (JsonSerializable)this.offlineConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationPropertiesSqlVm fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationPropertiesSqlVm)jsonReader.readObject(reader -> {
            DatabaseMigrationPropertiesSqlVm deserializedDatabaseMigrationPropertiesSqlVm = new DatabaseMigrationPropertiesSqlVm();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withScope(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withMigrationStatus(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withStartedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withEndedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("migrationService".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withMigrationService(reader.getString());
                    continue;
                }
                if ("migrationOperationId".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withMigrationOperationId(reader.getString());
                    continue;
                }
                if ("migrationFailureError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withMigrationFailureError(ErrorInfo.fromJson(reader));
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withProvisioningError(reader.getString());
                    continue;
                }
                if ("sourceSqlConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withSourceSqlConnection(SqlConnectionInformation.fromJson(reader));
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withSourceDatabaseName(reader.getString());
                    continue;
                }
                if ("sourceServerName".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withSourceServerName(reader.getString());
                    continue;
                }
                if ("targetDatabaseCollation".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.withTargetDatabaseCollation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.kind = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("migrationStatusDetails".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.migrationStatusDetails = MigrationStatusDetails.fromJson(reader);
                    continue;
                }
                if ("backupConfiguration".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.backupConfiguration = BackupConfiguration.fromJson(reader);
                    continue;
                }
                if ("offlineConfiguration".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlVm.offlineConfiguration = OfflineConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationPropertiesSqlVm;
        });
    }
}

