/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationProperties;
import com.azure.resourcemanager.datamigration.models.ErrorInfo;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import com.azure.resourcemanager.datamigration.models.ResourceType;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInformation;
import com.azure.resourcemanager.datamigration.models.SqlDbMigrationStatusDetails;
import com.azure.resourcemanager.datamigration.models.SqlDbOfflineConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DatabaseMigrationPropertiesSqlDb
extends DatabaseMigrationProperties {
    private ResourceType kind = ResourceType.SQL_DB;
    private SqlDbMigrationStatusDetails migrationStatusDetails;
    private SqlConnectionInformation targetSqlConnection;
    private SqlDbOfflineConfiguration offlineConfiguration;
    private List<String> tableList;

    @Override
    public ResourceType kind() {
        return this.kind;
    }

    public SqlDbMigrationStatusDetails migrationStatusDetails() {
        return this.migrationStatusDetails;
    }

    public SqlConnectionInformation targetSqlConnection() {
        return this.targetSqlConnection;
    }

    public DatabaseMigrationPropertiesSqlDb withTargetSqlConnection(SqlConnectionInformation targetSqlConnection) {
        this.targetSqlConnection = targetSqlConnection;
        return this;
    }

    public SqlDbOfflineConfiguration offlineConfiguration() {
        return this.offlineConfiguration;
    }

    public List<String> tableList() {
        return this.tableList;
    }

    public DatabaseMigrationPropertiesSqlDb withTableList(List<String> tableList) {
        this.tableList = tableList;
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withSourceSqlConnection(SqlConnectionInformation sourceSqlConnection) {
        super.withSourceSqlConnection(sourceSqlConnection);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withSourceDatabaseName(String sourceDatabaseName) {
        super.withSourceDatabaseName(sourceDatabaseName);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withTargetDatabaseCollation(String targetDatabaseCollation) {
        super.withTargetDatabaseCollation(targetDatabaseCollation);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withScope(String scope) {
        super.withScope(scope);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withMigrationService(String migrationService) {
        super.withMigrationService(migrationService);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withMigrationOperationId(String migrationOperationId) {
        super.withMigrationOperationId(migrationOperationId);
        return this;
    }

    @Override
    public DatabaseMigrationPropertiesSqlDb withProvisioningError(String provisioningError) {
        super.withProvisioningError(provisioningError);
        return this;
    }

    @Override
    public void validate() {
        if (this.migrationStatusDetails() != null) {
            this.migrationStatusDetails().validate();
        }
        if (this.targetSqlConnection() != null) {
            this.targetSqlConnection().validate();
        }
        if (this.offlineConfiguration() != null) {
            this.offlineConfiguration().validate();
        }
        if (this.migrationFailureError() != null) {
            this.migrationFailureError().validate();
        }
        if (this.sourceSqlConnection() != null) {
            this.sourceSqlConnection().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope());
        jsonWriter.writeStringField("migrationService", this.migrationService());
        jsonWriter.writeStringField("migrationOperationId", this.migrationOperationId());
        jsonWriter.writeStringField("provisioningError", this.provisioningError());
        jsonWriter.writeJsonField("sourceSqlConnection", (JsonSerializable)this.sourceSqlConnection());
        jsonWriter.writeStringField("sourceDatabaseName", this.sourceDatabaseName());
        jsonWriter.writeStringField("targetDatabaseCollation", this.targetDatabaseCollation());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("targetSqlConnection", (JsonSerializable)this.targetSqlConnection);
        jsonWriter.writeArrayField("tableList", this.tableList, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationPropertiesSqlDb fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationPropertiesSqlDb)jsonReader.readObject(reader -> {
            DatabaseMigrationPropertiesSqlDb deserializedDatabaseMigrationPropertiesSqlDb = new DatabaseMigrationPropertiesSqlDb();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withScope(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withMigrationStatus(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withStartedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withEndedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("migrationService".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withMigrationService(reader.getString());
                    continue;
                }
                if ("migrationOperationId".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withMigrationOperationId(reader.getString());
                    continue;
                }
                if ("migrationFailureError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withMigrationFailureError(ErrorInfo.fromJson(reader));
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withProvisioningError(reader.getString());
                    continue;
                }
                if ("sourceSqlConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withSourceSqlConnection(SqlConnectionInformation.fromJson(reader));
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withSourceDatabaseName(reader.getString());
                    continue;
                }
                if ("sourceServerName".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withSourceServerName(reader.getString());
                    continue;
                }
                if ("targetDatabaseCollation".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.withTargetDatabaseCollation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.kind = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("migrationStatusDetails".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.migrationStatusDetails = SqlDbMigrationStatusDetails.fromJson(reader);
                    continue;
                }
                if ("targetSqlConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.targetSqlConnection = SqlConnectionInformation.fromJson(reader);
                    continue;
                }
                if ("offlineConfiguration".equals(fieldName)) {
                    deserializedDatabaseMigrationPropertiesSqlDb.offlineConfiguration = SqlDbOfflineConfiguration.fromJson(reader);
                    continue;
                }
                if ("tableList".equals(fieldName)) {
                    List tableList;
                    deserializedDatabaseMigrationPropertiesSqlDb.tableList = tableList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationPropertiesSqlDb;
        });
    }
}

