/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationBaseProperties;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlDb;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlMi;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlVm;
import com.azure.resourcemanager.datamigration.models.ErrorInfo;
import com.azure.resourcemanager.datamigration.models.ProvisioningState;
import com.azure.resourcemanager.datamigration.models.ResourceType;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInformation;
import java.io.IOException;
import java.time.OffsetDateTime;

public class DatabaseMigrationProperties
extends DatabaseMigrationBaseProperties {
    private ResourceType kind = ResourceType.fromString("DatabaseMigrationProperties");
    private SqlConnectionInformation sourceSqlConnection;
    private String sourceDatabaseName;
    private String sourceServerName;
    private String targetDatabaseCollation;

    @Override
    public ResourceType kind() {
        return this.kind;
    }

    public SqlConnectionInformation sourceSqlConnection() {
        return this.sourceSqlConnection;
    }

    public DatabaseMigrationProperties withSourceSqlConnection(SqlConnectionInformation sourceSqlConnection) {
        this.sourceSqlConnection = sourceSqlConnection;
        return this;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public DatabaseMigrationProperties withSourceDatabaseName(String sourceDatabaseName) {
        this.sourceDatabaseName = sourceDatabaseName;
        return this;
    }

    public String sourceServerName() {
        return this.sourceServerName;
    }

    DatabaseMigrationProperties withSourceServerName(String sourceServerName) {
        this.sourceServerName = sourceServerName;
        return this;
    }

    public String targetDatabaseCollation() {
        return this.targetDatabaseCollation;
    }

    public DatabaseMigrationProperties withTargetDatabaseCollation(String targetDatabaseCollation) {
        this.targetDatabaseCollation = targetDatabaseCollation;
        return this;
    }

    @Override
    public DatabaseMigrationProperties withScope(String scope) {
        super.withScope(scope);
        return this;
    }

    @Override
    public DatabaseMigrationProperties withMigrationService(String migrationService) {
        super.withMigrationService(migrationService);
        return this;
    }

    @Override
    public DatabaseMigrationProperties withMigrationOperationId(String migrationOperationId) {
        super.withMigrationOperationId(migrationOperationId);
        return this;
    }

    @Override
    public DatabaseMigrationProperties withProvisioningError(String provisioningError) {
        super.withProvisioningError(provisioningError);
        return this;
    }

    @Override
    public void validate() {
        if (this.sourceSqlConnection() != null) {
            this.sourceSqlConnection().validate();
        }
        if (this.migrationFailureError() != null) {
            this.migrationFailureError().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope());
        jsonWriter.writeStringField("migrationService", this.migrationService());
        jsonWriter.writeStringField("migrationOperationId", this.migrationOperationId());
        jsonWriter.writeStringField("provisioningError", this.provisioningError());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("sourceSqlConnection", (JsonSerializable)this.sourceSqlConnection);
        jsonWriter.writeStringField("sourceDatabaseName", this.sourceDatabaseName);
        jsonWriter.writeStringField("targetDatabaseCollation", this.targetDatabaseCollation);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseMigrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatabaseMigrationProperties databaseMigrationProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SqlDb".equals(discriminatorValue)) {
                    databaseMigrationProperties = DatabaseMigrationPropertiesSqlDb.fromJson(readerToUse.reset());
                    return databaseMigrationProperties;
                }
                if ("SqlMi".equals(discriminatorValue)) {
                    databaseMigrationProperties = DatabaseMigrationPropertiesSqlMi.fromJson(readerToUse.reset());
                    return databaseMigrationProperties;
                }
                if ("SqlVm".equals(discriminatorValue)) {
                    databaseMigrationProperties = DatabaseMigrationPropertiesSqlVm.fromJson(readerToUse.reset());
                    return databaseMigrationProperties;
                }
                databaseMigrationProperties = DatabaseMigrationProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return databaseMigrationProperties;
            }
        });
    }

    static DatabaseMigrationProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatabaseMigrationProperties)jsonReader.readObject(reader -> {
            DatabaseMigrationProperties deserializedDatabaseMigrationProperties = new DatabaseMigrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withScope(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("migrationStatus".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withMigrationStatus(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withStartedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withEndedOn((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("migrationService".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withMigrationService(reader.getString());
                    continue;
                }
                if ("migrationOperationId".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withMigrationOperationId(reader.getString());
                    continue;
                }
                if ("migrationFailureError".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withMigrationFailureError(ErrorInfo.fromJson(reader));
                    continue;
                }
                if ("provisioningError".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.withProvisioningError(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.kind = ResourceType.fromString(reader.getString());
                    continue;
                }
                if ("sourceSqlConnection".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.sourceSqlConnection = SqlConnectionInformation.fromJson(reader);
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.sourceDatabaseName = reader.getString();
                    continue;
                }
                if ("sourceServerName".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.sourceServerName = reader.getString();
                    continue;
                }
                if ("targetDatabaseCollation".equals(fieldName)) {
                    deserializedDatabaseMigrationProperties.targetDatabaseCollation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseMigrationProperties;
        });
    }
}

