/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseFileType;
import java.io.IOException;

public final class DatabaseFileInfo
implements JsonSerializable<DatabaseFileInfo> {
    private String databaseName;
    private String id;
    private String logicalName;
    private String physicalFullName;
    private String restoreFullName;
    private DatabaseFileType fileType;
    private Double sizeMB;

    public String databaseName() {
        return this.databaseName;
    }

    public DatabaseFileInfo withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String id() {
        return this.id;
    }

    public DatabaseFileInfo withId(String id) {
        this.id = id;
        return this;
    }

    public String logicalName() {
        return this.logicalName;
    }

    public DatabaseFileInfo withLogicalName(String logicalName) {
        this.logicalName = logicalName;
        return this;
    }

    public String physicalFullName() {
        return this.physicalFullName;
    }

    public DatabaseFileInfo withPhysicalFullName(String physicalFullName) {
        this.physicalFullName = physicalFullName;
        return this;
    }

    public String restoreFullName() {
        return this.restoreFullName;
    }

    public DatabaseFileInfo withRestoreFullName(String restoreFullName) {
        this.restoreFullName = restoreFullName;
        return this;
    }

    public DatabaseFileType fileType() {
        return this.fileType;
    }

    public DatabaseFileInfo withFileType(DatabaseFileType fileType) {
        this.fileType = fileType;
        return this;
    }

    public Double sizeMB() {
        return this.sizeMB;
    }

    public DatabaseFileInfo withSizeMB(Double sizeMB) {
        this.sizeMB = sizeMB;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("logicalName", this.logicalName);
        jsonWriter.writeStringField("physicalFullName", this.physicalFullName);
        jsonWriter.writeStringField("restoreFullName", this.restoreFullName);
        jsonWriter.writeStringField("fileType", this.fileType == null ? null : this.fileType.toString());
        jsonWriter.writeNumberField("sizeMB", (Number)this.sizeMB);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseFileInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseFileInfo)jsonReader.readObject(reader -> {
            DatabaseFileInfo deserializedDatabaseFileInfo = new DatabaseFileInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedDatabaseFileInfo.databaseName = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedDatabaseFileInfo.id = reader.getString();
                    continue;
                }
                if ("logicalName".equals(fieldName)) {
                    deserializedDatabaseFileInfo.logicalName = reader.getString();
                    continue;
                }
                if ("physicalFullName".equals(fieldName)) {
                    deserializedDatabaseFileInfo.physicalFullName = reader.getString();
                    continue;
                }
                if ("restoreFullName".equals(fieldName)) {
                    deserializedDatabaseFileInfo.restoreFullName = reader.getString();
                    continue;
                }
                if ("fileType".equals(fieldName)) {
                    deserializedDatabaseFileInfo.fileType = DatabaseFileType.fromString(reader.getString());
                    continue;
                }
                if ("sizeMB".equals(fieldName)) {
                    deserializedDatabaseFileInfo.sizeMB = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseFileInfo;
        });
    }
}

