/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class ConnectToTargetSqlMITaskOutput
implements JsonSerializable<ConnectToTargetSqlMITaskOutput> {
    private String id;
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private List<String> logins;
    private List<String> agentJobs;
    private List<ReportableException> validationErrors;

    public String id() {
        return this.id;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public List<String> logins() {
        return this.logins;
    }

    public List<String> agentJobs() {
        return this.agentJobs;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlMITaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlMITaskOutput)jsonReader.readObject(reader -> {
            ConnectToTargetSqlMITaskOutput deserializedConnectToTargetSqlMITaskOutput = new ConnectToTargetSqlMITaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskOutput.id = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskOutput.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskOutput.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("logins".equals(fieldName)) {
                    List logins;
                    deserializedConnectToTargetSqlMITaskOutput.logins = logins = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("agentJobs".equals(fieldName)) {
                    List agentJobs;
                    deserializedConnectToTargetSqlMITaskOutput.agentJobs = agentJobs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedConnectToTargetSqlMITaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlMITaskOutput;
        });
    }
}

