/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;

public final class ConnectToTargetSqlMITaskInput
implements JsonSerializable<ConnectToTargetSqlMITaskInput> {
    private SqlConnectionInfo targetConnectionInfo;
    private Boolean collectLogins;
    private Boolean collectAgentJobs;
    private Boolean validateSsisCatalogOnly;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToTargetSqlMITaskInput.class);

    public SqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ConnectToTargetSqlMITaskInput withTargetConnectionInfo(SqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public Boolean collectLogins() {
        return this.collectLogins;
    }

    public ConnectToTargetSqlMITaskInput withCollectLogins(Boolean collectLogins) {
        this.collectLogins = collectLogins;
        return this;
    }

    public Boolean collectAgentJobs() {
        return this.collectAgentJobs;
    }

    public ConnectToTargetSqlMITaskInput withCollectAgentJobs(Boolean collectAgentJobs) {
        this.collectAgentJobs = collectAgentJobs;
        return this;
    }

    public Boolean validateSsisCatalogOnly() {
        return this.validateSsisCatalogOnly;
    }

    public ConnectToTargetSqlMITaskInput withValidateSsisCatalogOnly(Boolean validateSsisCatalogOnly) {
        this.validateSsisCatalogOnly = validateSsisCatalogOnly;
        return this;
    }

    public void validate() {
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ConnectToTargetSqlMITaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeBooleanField("collectLogins", this.collectLogins);
        jsonWriter.writeBooleanField("collectAgentJobs", this.collectAgentJobs);
        jsonWriter.writeBooleanField("validateSsisCatalogOnly", this.validateSsisCatalogOnly);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlMITaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlMITaskInput)jsonReader.readObject(reader -> {
            ConnectToTargetSqlMITaskInput deserializedConnectToTargetSqlMITaskInput = new ConnectToTargetSqlMITaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskInput.targetConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("collectLogins".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskInput.collectLogins = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("collectAgentJobs".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskInput.collectAgentJobs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("validateSsisCatalogOnly".equals(fieldName)) {
                    deserializedConnectToTargetSqlMITaskInput.validateSsisCatalogOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlMITaskInput;
        });
    }
}

