/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceSqlServerTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationEligibilityInfo;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ConnectToSourceSqlServerTaskOutputAgentJobLevel
extends ConnectToSourceSqlServerTaskOutput {
    private String resultType = "AgentJobLevelOutput";
    private String name;
    private String jobCategory;
    private Boolean isEnabled;
    private String jobOwner;
    private OffsetDateTime lastExecutedOn;
    private List<ReportableException> validationErrors;
    private MigrationEligibilityInfo migrationEligibility;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String name() {
        return this.name;
    }

    public String jobCategory() {
        return this.jobCategory;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public String jobOwner() {
        return this.jobOwner;
    }

    public OffsetDateTime lastExecutedOn() {
        return this.lastExecutedOn;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public MigrationEligibilityInfo migrationEligibility() {
        return this.migrationEligibility;
    }

    @Override
    public void validate() {
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
        if (this.migrationEligibility() != null) {
            this.migrationEligibility().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceSqlServerTaskOutputAgentJobLevel fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceSqlServerTaskOutputAgentJobLevel)jsonReader.readObject(reader -> {
            ConnectToSourceSqlServerTaskOutputAgentJobLevel deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel = new ConnectToSourceSqlServerTaskOutputAgentJobLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.resultType = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.name = reader.getString();
                    continue;
                }
                if ("jobCategory".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.jobCategory = reader.getString();
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("jobOwner".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.jobOwner = reader.getString();
                    continue;
                }
                if ("lastExecutedOn".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.lastExecutedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("migrationEligibility".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel.migrationEligibility = MigrationEligibilityInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceSqlServerTaskOutputAgentJobLevel;
        });
    }
}

