/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ServerLevelPermissionsGroup;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;

public final class ConnectToSourceSqlServerTaskInput
implements JsonSerializable<ConnectToSourceSqlServerTaskInput> {
    private SqlConnectionInfo sourceConnectionInfo;
    private ServerLevelPermissionsGroup checkPermissionsGroup;
    private Boolean collectDatabases;
    private Boolean collectLogins;
    private Boolean collectAgentJobs;
    private Boolean collectTdeCertificateInfo;
    private Boolean validateSsisCatalogOnly;
    private String encryptedKeyForSecureFields;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToSourceSqlServerTaskInput.class);

    public SqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ConnectToSourceSqlServerTaskInput withSourceConnectionInfo(SqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public ServerLevelPermissionsGroup checkPermissionsGroup() {
        return this.checkPermissionsGroup;
    }

    public ConnectToSourceSqlServerTaskInput withCheckPermissionsGroup(ServerLevelPermissionsGroup checkPermissionsGroup) {
        this.checkPermissionsGroup = checkPermissionsGroup;
        return this;
    }

    public Boolean collectDatabases() {
        return this.collectDatabases;
    }

    public ConnectToSourceSqlServerTaskInput withCollectDatabases(Boolean collectDatabases) {
        this.collectDatabases = collectDatabases;
        return this;
    }

    public Boolean collectLogins() {
        return this.collectLogins;
    }

    public ConnectToSourceSqlServerTaskInput withCollectLogins(Boolean collectLogins) {
        this.collectLogins = collectLogins;
        return this;
    }

    public Boolean collectAgentJobs() {
        return this.collectAgentJobs;
    }

    public ConnectToSourceSqlServerTaskInput withCollectAgentJobs(Boolean collectAgentJobs) {
        this.collectAgentJobs = collectAgentJobs;
        return this;
    }

    public Boolean collectTdeCertificateInfo() {
        return this.collectTdeCertificateInfo;
    }

    public ConnectToSourceSqlServerTaskInput withCollectTdeCertificateInfo(Boolean collectTdeCertificateInfo) {
        this.collectTdeCertificateInfo = collectTdeCertificateInfo;
        return this;
    }

    public Boolean validateSsisCatalogOnly() {
        return this.validateSsisCatalogOnly;
    }

    public ConnectToSourceSqlServerTaskInput withValidateSsisCatalogOnly(Boolean validateSsisCatalogOnly) {
        this.validateSsisCatalogOnly = validateSsisCatalogOnly;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public ConnectToSourceSqlServerTaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ConnectToSourceSqlServerTaskInput"));
        }
        this.sourceConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeStringField("checkPermissionsGroup", this.checkPermissionsGroup == null ? null : this.checkPermissionsGroup.toString());
        jsonWriter.writeBooleanField("collectDatabases", this.collectDatabases);
        jsonWriter.writeBooleanField("collectLogins", this.collectLogins);
        jsonWriter.writeBooleanField("collectAgentJobs", this.collectAgentJobs);
        jsonWriter.writeBooleanField("collectTdeCertificateInfo", this.collectTdeCertificateInfo);
        jsonWriter.writeBooleanField("validateSsisCatalogOnly", this.validateSsisCatalogOnly);
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceSqlServerTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceSqlServerTaskInput)jsonReader.readObject(reader -> {
            ConnectToSourceSqlServerTaskInput deserializedConnectToSourceSqlServerTaskInput = new ConnectToSourceSqlServerTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.sourceConnectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("checkPermissionsGroup".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.checkPermissionsGroup = ServerLevelPermissionsGroup.fromString(reader.getString());
                    continue;
                }
                if ("collectDatabases".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.collectDatabases = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("collectLogins".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.collectLogins = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("collectAgentJobs".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.collectAgentJobs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("collectTdeCertificateInfo".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.collectTdeCertificateInfo = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("validateSsisCatalogOnly".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.validateSsisCatalogOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceSqlServerTaskInput;
        });
    }
}

