/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.OracleConnectionInfo;
import java.io.IOException;

public final class ConnectToSourceOracleSyncTaskInput
implements JsonSerializable<ConnectToSourceOracleSyncTaskInput> {
    private OracleConnectionInfo sourceConnectionInfo;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToSourceOracleSyncTaskInput.class);

    public OracleConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ConnectToSourceOracleSyncTaskInput withSourceConnectionInfo(OracleConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ConnectToSourceOracleSyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceOracleSyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceOracleSyncTaskInput)jsonReader.readObject(reader -> {
            ConnectToSourceOracleSyncTaskInput deserializedConnectToSourceOracleSyncTaskInput = new ConnectToSourceOracleSyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedConnectToSourceOracleSyncTaskInput.sourceConnectionInfo = OracleConnectionInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceOracleSyncTaskInput;
        });
    }
}

