/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.OracleOciDriverInfo;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class CheckOciDriverTaskOutput
implements JsonSerializable<CheckOciDriverTaskOutput> {
    private OracleOciDriverInfo installedDriver;
    private List<ReportableException> validationErrors;

    public OracleOciDriverInfo installedDriver() {
        return this.installedDriver;
    }

    public CheckOciDriverTaskOutput withInstalledDriver(OracleOciDriverInfo installedDriver) {
        this.installedDriver = installedDriver;
        return this;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    public void validate() {
        if (this.installedDriver() != null) {
            this.installedDriver().validate();
        }
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("installedDriver", (JsonSerializable)this.installedDriver);
        return jsonWriter.writeEndObject();
    }

    public static CheckOciDriverTaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (CheckOciDriverTaskOutput)jsonReader.readObject(reader -> {
            CheckOciDriverTaskOutput deserializedCheckOciDriverTaskOutput = new CheckOciDriverTaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("installedDriver".equals(fieldName)) {
                    deserializedCheckOciDriverTaskOutput.installedDriver = OracleOciDriverInfo.fromJson(reader);
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedCheckOciDriverTaskOutput.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckOciDriverTaskOutput;
        });
    }
}

