/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AuthType;
import com.azure.resourcemanager.datamigration.models.ManagedServiceIdentity;
import java.io.IOException;

public final class AzureBlob
implements JsonSerializable<AzureBlob> {
    private AuthType authType;
    private ManagedServiceIdentity identity;
    private String storageAccountResourceId;
    private String accountKey;
    private String blobContainerName;

    public AuthType authType() {
        return this.authType;
    }

    public AzureBlob withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public AzureBlob withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    public AzureBlob withStorageAccountResourceId(String storageAccountResourceId) {
        this.storageAccountResourceId = storageAccountResourceId;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public AzureBlob withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public String blobContainerName() {
        return this.blobContainerName;
    }

    public AzureBlob withBlobContainerName(String blobContainerName) {
        this.blobContainerName = blobContainerName;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authType", this.authType == null ? null : this.authType.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeStringField("storageAccountResourceId", this.storageAccountResourceId);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("blobContainerName", this.blobContainerName);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlob fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlob)jsonReader.readObject(reader -> {
            AzureBlob deserializedAzureBlob = new AzureBlob();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authType".equals(fieldName)) {
                    deserializedAzureBlob.authType = AuthType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedAzureBlob.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("storageAccountResourceId".equals(fieldName)) {
                    deserializedAzureBlob.storageAccountResourceId = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureBlob.accountKey = reader.getString();
                    continue;
                }
                if ("blobContainerName".equals(fieldName)) {
                    deserializedAzureBlob.blobContainerName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlob;
        });
    }
}

