/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datamigration.fluent.SqlMigrationServicesClient;
import com.azure.resourcemanager.datamigration.fluent.models.AuthenticationKeysInner;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationInner;
import com.azure.resourcemanager.datamigration.fluent.models.DeleteNodeInner;
import com.azure.resourcemanager.datamigration.fluent.models.IntegrationRuntimeMonitoringDataInner;
import com.azure.resourcemanager.datamigration.fluent.models.RegenAuthKeysInner;
import com.azure.resourcemanager.datamigration.fluent.models.SqlMigrationServiceInner;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientImpl;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationListResult;
import com.azure.resourcemanager.datamigration.models.SqlMigrationListResult;
import com.azure.resourcemanager.datamigration.models.SqlMigrationServiceUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SqlMigrationServicesClientImpl
implements SqlMigrationServicesClient {
    private final SqlMigrationServicesService service;
    private final DataMigrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(SqlMigrationServicesClientImpl.class);

    SqlMigrationServicesClientImpl(DataMigrationManagementClientImpl client) {
        this.service = (SqlMigrationServicesService)RestProxy.create(SqlMigrationServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SqlMigrationServiceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SqlMigrationServiceInner> getByResourceGroupAsync(String resourceGroupName, String sqlMigrationServiceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, sqlMigrationServiceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SqlMigrationServiceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlMigrationServiceInner> getByResourceGroupWithResponse(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlMigrationServiceInner getByResourceGroup(String resourceGroupName, String sqlMigrationServiceName) {
        return (SqlMigrationServiceInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, sqlMigrationServiceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlMigrationServiceInner>, SqlMigrationServiceInner> beginCreateOrUpdateAsync(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, sqlMigrationServiceName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SqlMigrationServiceInner.class), (Type)((Object)SqlMigrationServiceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlMigrationServiceInner>, SqlMigrationServiceInner> beginCreateOrUpdate(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, sqlMigrationServiceName, parameters);
        return this.client.getLroResult(response, (Type)((Object)SqlMigrationServiceInner.class), (Type)((Object)SqlMigrationServiceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlMigrationServiceInner>, SqlMigrationServiceInner> beginCreateOrUpdate(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, sqlMigrationServiceName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)SqlMigrationServiceInner.class), (Type)((Object)SqlMigrationServiceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SqlMigrationServiceInner> createOrUpdateAsync(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, sqlMigrationServiceName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlMigrationServiceInner createOrUpdate(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters) {
        return (SqlMigrationServiceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, sqlMigrationServiceName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlMigrationServiceInner createOrUpdate(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceInner parameters, Context context) {
        return (SqlMigrationServiceInner)((Object)this.beginCreateOrUpdate(resourceGroupName, sqlMigrationServiceName, parameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sqlMigrationServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, sqlMigrationServiceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sqlMigrationServiceName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, sqlMigrationServiceName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, sqlMigrationServiceName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sqlMigrationServiceName) {
        return this.beginDeleteAsync(resourceGroupName, sqlMigrationServiceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sqlMigrationServiceName) {
        this.beginDelete(resourceGroupName, sqlMigrationServiceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        this.beginDelete(resourceGroupName, sqlMigrationServiceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlMigrationServiceInner>, SqlMigrationServiceInner> beginUpdateAsync(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, sqlMigrationServiceName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SqlMigrationServiceInner.class), (Type)((Object)SqlMigrationServiceInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlMigrationServiceInner>, SqlMigrationServiceInner> beginUpdate(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, sqlMigrationServiceName, parameters);
        return this.client.getLroResult(response, (Type)((Object)SqlMigrationServiceInner.class), (Type)((Object)SqlMigrationServiceInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlMigrationServiceInner>, SqlMigrationServiceInner> beginUpdate(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, sqlMigrationServiceName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)SqlMigrationServiceInner.class), (Type)((Object)SqlMigrationServiceInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SqlMigrationServiceInner> updateAsync(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters) {
        return this.beginUpdateAsync(resourceGroupName, sqlMigrationServiceName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlMigrationServiceInner update(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters) {
        return (SqlMigrationServiceInner)((Object)this.beginUpdate(resourceGroupName, sqlMigrationServiceName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlMigrationServiceInner update(String resourceGroupName, String sqlMigrationServiceName, SqlMigrationServiceUpdate parameters, Context context) {
        return (SqlMigrationServiceInner)((Object)this.beginUpdate(resourceGroupName, sqlMigrationServiceName, parameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlMigrationServiceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SqlMigrationServiceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listByResourceGroupSinglePage(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlMigrationServiceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlMigrationServiceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AuthenticationKeysInner>> listAuthKeysWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAuthKeys(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AuthenticationKeysInner> listAuthKeysAsync(String resourceGroupName, String sqlMigrationServiceName) {
        return this.listAuthKeysWithResponseAsync(resourceGroupName, sqlMigrationServiceName).flatMap(res -> Mono.justOrEmpty((Object)((AuthenticationKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AuthenticationKeysInner> listAuthKeysWithResponse(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.listAuthKeysSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AuthenticationKeysInner listAuthKeys(String resourceGroupName, String sqlMigrationServiceName) {
        return (AuthenticationKeysInner)this.listAuthKeysWithResponse(resourceGroupName, sqlMigrationServiceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegenAuthKeysInner>> regenerateAuthKeysWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName, RegenAuthKeysInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerateAuthKeys(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RegenAuthKeysInner> regenerateAuthKeysAsync(String resourceGroupName, String sqlMigrationServiceName, RegenAuthKeysInner parameters) {
        return this.regenerateAuthKeysWithResponseAsync(resourceGroupName, sqlMigrationServiceName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((RegenAuthKeysInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RegenAuthKeysInner> regenerateAuthKeysWithResponse(String resourceGroupName, String sqlMigrationServiceName, RegenAuthKeysInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.regenerateAuthKeysSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RegenAuthKeysInner regenerateAuthKeys(String resourceGroupName, String sqlMigrationServiceName, RegenAuthKeysInner parameters) {
        return (RegenAuthKeysInner)this.regenerateAuthKeysWithResponse(resourceGroupName, sqlMigrationServiceName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeleteNodeInner>> deleteNodeWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName, DeleteNodeInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNode(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DeleteNodeInner> deleteNodeAsync(String resourceGroupName, String sqlMigrationServiceName, DeleteNodeInner parameters) {
        return this.deleteNodeWithResponseAsync(resourceGroupName, sqlMigrationServiceName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((DeleteNodeInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeleteNodeInner> deleteNodeWithResponse(String resourceGroupName, String sqlMigrationServiceName, DeleteNodeInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.deleteNodeSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeleteNodeInner deleteNode(String resourceGroupName, String sqlMigrationServiceName, DeleteNodeInner parameters) {
        return (DeleteNodeInner)this.deleteNodeWithResponse(resourceGroupName, sqlMigrationServiceName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseMigrationInner>> listMigrationsSinglePageAsync(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMigrations(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationListResult)res.getValue()).value(), ((DatabaseMigrationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DatabaseMigrationInner> listMigrationsAsync(String resourceGroupName, String sqlMigrationServiceName) {
        return new PagedFlux(() -> this.listMigrationsSinglePageAsync(resourceGroupName, sqlMigrationServiceName), nextLink -> this.listMigrationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationInner> listMigrationsSinglePage(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationListResult> res = this.service.listMigrationsSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationListResult)res.getValue()).value(), ((DatabaseMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationInner> listMigrationsSinglePage(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationListResult> res = this.service.listMigrationsSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationListResult)res.getValue()).value(), ((DatabaseMigrationListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseMigrationInner> listMigrations(String resourceGroupName, String sqlMigrationServiceName) {
        return new PagedIterable(() -> this.listMigrationsSinglePage(resourceGroupName, sqlMigrationServiceName), nextLink -> this.listMigrationsNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatabaseMigrationInner> listMigrations(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        return new PagedIterable(() -> this.listMigrationsSinglePage(resourceGroupName, sqlMigrationServiceName, context), nextLink -> this.listMigrationsNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IntegrationRuntimeMonitoringDataInner>> listMonitoringDataWithResponseAsync(String resourceGroupName, String sqlMigrationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMonitoringData(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IntegrationRuntimeMonitoringDataInner> listMonitoringDataAsync(String resourceGroupName, String sqlMigrationServiceName) {
        return this.listMonitoringDataWithResponseAsync(resourceGroupName, sqlMigrationServiceName).flatMap(res -> Mono.justOrEmpty((Object)((IntegrationRuntimeMonitoringDataInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IntegrationRuntimeMonitoringDataInner> listMonitoringDataWithResponse(String resourceGroupName, String sqlMigrationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlMigrationServiceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlMigrationServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.listMonitoringDataSync(this.client.getEndpoint(), resourceGroupName, sqlMigrationServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IntegrationRuntimeMonitoringDataInner listMonitoringData(String resourceGroupName, String sqlMigrationServiceName) {
        return (IntegrationRuntimeMonitoringDataInner)this.listMonitoringDataWithResponse(resourceGroupName, sqlMigrationServiceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlMigrationServiceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SqlMigrationServiceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlMigrationServiceInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlMigrationServiceInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlMigrationServiceInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listByResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DatabaseMigrationInner>> listMigrationsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMigrationsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationListResult)res.getValue()).value(), ((DatabaseMigrationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationInner> listMigrationsNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationListResult> res = this.service.listMigrationsNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationListResult)res.getValue()).value(), ((DatabaseMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<DatabaseMigrationInner> listMigrationsNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<DatabaseMigrationListResult> res = this.service.listMigrationsNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DatabaseMigrationListResult)res.getValue()).value(), ((DatabaseMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SqlMigrationServiceInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listBySubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<SqlMigrationServiceInner> listBySubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<SqlMigrationListResult> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlMigrationListResult)res.getValue()).value(), ((SqlMigrationListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataMigrationManagementClientSqlMigrationServices")
    public static interface SqlMigrationServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlMigrationServiceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SqlMigrationServiceInner> getByResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SqlMigrationServiceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SqlMigrationServiceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SqlMigrationServiceUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SqlMigrationServiceUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlMigrationListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SqlMigrationListResult> listByResourceGroupSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listAuthKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AuthenticationKeysInner>> listAuthKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listAuthKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AuthenticationKeysInner> listAuthKeysSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/regenerateAuthKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegenAuthKeysInner>> regenerateAuthKeys(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RegenAuthKeysInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/regenerateAuthKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<RegenAuthKeysInner> regenerateAuthKeysSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") RegenAuthKeysInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/deleteNode")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DeleteNodeInner>> deleteNode(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DeleteNodeInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/deleteNode")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DeleteNodeInner> deleteNodeSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") DeleteNodeInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listMigrations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationListResult>> listMigrations(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listMigrations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationListResult> listMigrationsSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listMonitoringData")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IntegrationRuntimeMonitoringDataInner>> listMonitoringData(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataMigration/sqlMigrationServices/{sqlMigrationServiceName}/listMonitoringData")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<IntegrationRuntimeMonitoringDataInner> listMonitoringDataSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlMigrationServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/sqlMigrationServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlMigrationListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataMigration/sqlMigrationServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SqlMigrationListResult> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlMigrationListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SqlMigrationListResult> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationListResult>> listMigrationsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationListResult> listMigrationsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SqlMigrationListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SqlMigrationListResult> listBySubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

